/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed.parser;

import java.io.IOException;
import java.io.PushbackReader;

import net.morilib.sed.SedCommand;
import net.morilib.sed.SedCommandBundle;
import net.morilib.sed.SedCommandParser;
import net.morilib.sed.SedLineOption;
import net.morilib.sed.SedSyntaxException;
import net.morilib.sed.cmd.SedWCommand;


public class SedWParser implements SedCommandParser {

	public SedCommand parse(SedCommandBundle bl,
			PushbackReader rd, SedLineOption l) throws IOException {
		StringBuffer b = new StringBuffer();
		int c;

		while((c = rd.read()) >= 0 && c != '\n') {
			b.appendCodePoint(c);
		}
		if(b.length() == 0)  throw new SedSyntaxException();
		return new SedWCommand(b.toString());
	}

}
