/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed.cmd;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import net.morilib.sed.SedCommand;
import net.morilib.sed.SedLineBuffer;
import net.morilib.sed.SedSpace;


public class SedLabel implements SedCommand {

	private static Map<String, SedLabel> instances =
		new HashMap<String, SedLabel>();

	//
	private String name;

	//
	private SedLabel(String name) {
		this.name = name;
	}

	public synchronized static SedLabel getInstance(String name) {
		SedLabel l;

		if((l = instances.get(name)) == null) {
			l = new SedLabel(name);
			instances.put(name, l);
		}
		return l;
	}

	public String getLongDescription() {
		return "label";
	}

	public char getName() {
		return ':';
	}

	public String getLabelName() {
		return name;
	}

	public void process(SedSpace s,
			SedLineBuffer rd) throws IOException {
		// no operation
	}

	public String toString() {
		return ":" + name;
	}

}
