/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed;

import java.util.HashMap;
import java.util.Map;

import net.morilib.sed.cmd.SedCommands;
import net.morilib.sed.parser.SedAParser;
import net.morilib.sed.parser.SedBParser;
import net.morilib.sed.parser.SedCParser;
import net.morilib.sed.parser.SedCommentParser;
import net.morilib.sed.parser.SedCompositeParser;
import net.morilib.sed.parser.SedIParser;
import net.morilib.sed.parser.SedLabelParser;
import net.morilib.sed.parser.SedQParser;
import net.morilib.sed.parser.SedRParser;
import net.morilib.sed.parser.SedSParser;
import net.morilib.sed.parser.SedSimpleCommandParser;
import net.morilib.sed.parser.SedTParser;
import net.morilib.sed.parser.SedWParser;
import net.morilib.sed.parser.SedYParser;

public class SedCommandBundle {

	//
	private static final SedCommandBundle DEFAULT;

	//
	private Map<Integer, SedCommandParser> cmds;

	static {
		Map<Integer, SedCommandParser> p;

		p = new HashMap<Integer, SedCommandParser>();
		p.put((int)'s', new SedSParser());
		p.put((int)'#', new SedCommentParser());
		p.put((int)'q', new SedQParser());
		p.put((int)'d', new SedSimpleCommandParser(SedCommands.D));
		p.put((int)'p', new SedSimpleCommandParser(SedCommands.P));
		p.put((int)'n', new SedSimpleCommandParser(SedCommands.N));
		p.put((int)'y', new SedYParser());
		p.put((int)'a', new SedAParser());
		p.put((int)'i', new SedIParser());
		p.put((int)'c', new SedCParser());
		p.put((int)'=', new SedSimpleCommandParser(SedCommands.EQ));
		p.put((int)'l', new SedSimpleCommandParser(SedCommands.L));
		p.put((int)'r', new SedRParser());
		p.put((int)'w', new SedWParser());
		p.put((int)'N', new SedSimpleCommandParser(SedCommands.NL));
		p.put((int)'P', new SedSimpleCommandParser(SedCommands.PL));
		p.put((int)'D', new SedSimpleCommandParser(SedCommands.DL));
		p.put((int)'h', new SedSimpleCommandParser(SedCommands.H));
		p.put((int)'H', new SedSimpleCommandParser(SedCommands.HL));
		p.put((int)'g', new SedSimpleCommandParser(SedCommands.G));
		p.put((int)'G', new SedSimpleCommandParser(SedCommands.GL));
		p.put((int)'x', new SedSimpleCommandParser(SedCommands.X));
		p.put((int)':', new SedLabelParser());
		p.put((int)'b', new SedBParser());
		p.put((int)'t', new SedTParser());
		p.put((int)'{', new SedCompositeParser());
		DEFAULT = new SedCommandBundle(p);
	}

	/**
	 * 
	 * @param cmds
	 */
	public SedCommandBundle(Map<Integer, SedCommandParser> cmds) {
		this.cmds = cmds;
	}

	/**
	 * 
	 * @return
	 */
	public static SedCommandBundle getInstance() {
		return DEFAULT;
	}

	/**
	 * 
	 * @param cmd
	 * @return
	 */
	public SedCommandParser get(int cmd) {
		return cmds.get(cmd);
	}

}
