<?php
/**
 * Storage.php
 *
 * PHP 5.4
 *
 * @package Auth
 *
 * @author Kaoru Sekiguchi <sekiguchi.kaoru@secioss.co.jp>
 * @copyright 2020 SECIOSS, INC.
 */
namespace Secioss\Simple;

/**
 * Secioss\Simple\Container
 */
interface Storage
{
    /**
     * ストレージへ接続
     */
    public function connect();

    /**
     * ストレージへ切断
     */
    public function disconnect();

    /**
     * ユーザー情報取得
     *
     * @param string $username ユーザーID
     *
     * @return mixed true:正常終了 PEAR_Error:エラー
     */
    public function fetchData($username);

    /**
     * ユーザー認証
     *
     * @param string $password ユーザーパスワード
     *
     * @return string 0:成功 1:失敗
     */
    public function auth($password);

    /**
     * ステータスを取得する。
     *
     * @return string ステータス
     */
    public function getStatus();

    /**
     * テナント情報取得
     *
     * @param null|string $tenant テナントID
     *
     * @return mixed テナント情報:正常終了 PEAR_Error:エラー
     */
    public function getTenants($tenant = null);

    /**
     * プロパティへのアクセサ(W)
     *
     * @param array $prop プロパティ
     *
     * @return mixed true:正常終了 PEAR_Error:エラー
     */
    public function setProp($prop);

    /**
     * プロパティへのアクセサ(W)
     *
     * @param array $prop プロパティ
     *
     * @return mixed true:正常終了 PEAR_Error:エラー
     */
    public function delProp($prop);

    /**
     * 暗号化されているシークレットを復号化して取得する
     *
     * @return string シークレット
     */
    public function getSecret();

    /**
     * シークレットを暗号化してLDAPに格納する
     *
     * @param string      $secret
     * @param null|string $pin
     * @param null|string $deviceid
     * @param null|string $device
     * @param null|int    $otplen
     * @param null|int    $timewindow
     * @param null|string $os
     * @param null|string $ip
     *
     * @return mixed true:正常終了 PEAR_Error:エラー
     */
    public function setSecret($secret, $pin = null, $deviceid = null, $device = null, $otplen = null, $timewindow = null, $os = null, $ip = null);
}
