<?php
/**
 * SSO.php
 *
 * PHP 5.4
 *
 * @package Auth
 *
 * @author Kaoru Sekiguchi <sekiguchi.kaoru@secioss.co.jp>
 * @copyright 2020 SECIOSS, INC.
 */
namespace Secioss\Simple;

use PEAR;

/**
 * Secioss\Simple\SSO
 */
class SSO implements Storage
{
    /**
     * SSOクラスのコンストラクタ
     *
     * @access public
     *
     * @param mixed $options SSOの設定
     *
     * @return mixed 0:正常終了 PEAR_Error:エラー
     */
    public function __construct($options)
    {
        $this->_setDefaults();
        $this->_parseOptions($options);

        return 0;
    }

    /**
     * optionsにデフォルト値を設定する
     *
     * @access private
     */
    public function _setDefaults()
    {
    }

    public function connect()
    {
    }

    public function disconnect()
    {
    }

    /**
     * ユーザ情報を取得する
     *
     * @param  string username
     * @param mixed $username
     *
     * @return mixed
     */
    public function fetchData($username)
    {
        if (!$username || strlen($username) > 255) {
            return PEAR::raiseError('Invalid user id', AUTO_LOGIN_INVALID_VALUE);
        }

        if ($username != $_SERVER['REMOTE_USER']) {
            return PEAR::raiseError("User doesn't exist", AUTO_LOGIN_NO_USER);
        }

        $this->id = $username;

        $this->prop = [];
        if (array_key_exists('REMOTE_USER_DATA', $_SERVER)) {
            foreach (preg_split('/#/', $_SERVER['REMOTE_USER_DATA']) as $elt) {
                list($attr, $values) = preg_split('/=/', $elt);
                $v = preg_split('/,/', $values);
                if (count($v) == 1) {
                    $this->prop[$attr] = $v[0];
                } else {
                    $this->prop[$attr] = $v;
                }
            }
        }

        if (isset($this->prop[$this->options['loginattr']])) {
            $this->loginid = $this->prop[$this->options['loginattr']];
        } else {
            $this->loginid = $this->id;
        }
    }

    public function auth($password)
    {
    }

    public function getStatus()
    {
    }

    public function getTenants($tenant = null)
    {
    }

    public function setProp($prop)
    {
    }

    public function delProp($prop)
    {
    }

    public function getSecret()
    {
    }

    public function setSecret($secret, $pin = null, $deviceid = null, $device = null, $otplen = null, $timewindow = null, $os = null, $ip = null)
    {
    }

    /**
     * optionsに値を設定する
     *
     * @access protected
     *
     * @param  array
     * @param mixed $array
     */
    protected function _parseOptions($array)
    {
        if (is_array($array)) {
            foreach ($array as $key => $value) {
                $this->options[$key] = $value;
            }
        }
    }
}
