<?php
/**
 * DB.php
 *
 * PHP 5.4
 *
 * @package Auth
 *
 * @author Kaoru Sekiguchi <sekiguchi.kaoru@secioss.co.jp>
 * @copyright 2020 SECIOSS, INC.
 */
namespace Secioss\Enterprise;

use PEAR;

define('PASSWORD_SYNTAX', '2.5.4.35');

/**
 * Secioss\Enterprise\DB
 */
class DB extends \Secioss\Simple\DB implements \Secioss\Enterprise\Storage
{
    /**
     * DBクラスのコンストラクタ
     *
     * @access public
     *
     * @param mixed $options DBの設定
     *
     * @return mixed 0:正常終了 PEAR_Error:エラー
     */
    public function __construct($options)
    {
        $this->_setDefaults();
        $this->_parseOptions($options);

        $rc = parent::__construct($options);

        return $rc;
    }

    /**
     * 暗号化されているパスワードを復号化して取得する
     *
     * @access public
     *
     * @return string パスワード
     */
    public function getPassword()
    {
        if (isset($this->prop[$this->options['encryptpwdcol']])) {
            return $this->decrypt($this->prop[$this->options['encryptpwdcol']]);
        } else {
            return '';
        }
    }

    /**
     * パスワードを暗号化してDBに格納する
     *
     * @access public
     *
     * @param string パスワード
     * @param null|mixed $password
     * @param null|mixed $app
     *
     * @return mixed true:正常終了 PEAR_Error:エラー
     */
    public function setPassword($password = null, $app = null)
    {
        if (!$this->id) {
            return PEAR::raiseError('Must fetch data', AUTO_LOGIN_ERROR);
        }

        if (!$password || strlen($password) > 255) {
            return PEAR::raiseError('Invalid password', AUTO_LOGIN_INVALID_VALUE);
        }

        $setval = $this->options['pwdcol']." = '".$this->hashPasswd($password)."'";
        if ($this->options['encryptpwdcol']) {
            $setval = $setval.', '.$this->options['encryptpwdcol']." = '".$encrypt."'";
        }
        if ($this->options['pwdtimecol']) {
            $setval = "$setval, ".$this->options['pwdtimecol']." = '".date('YmdHis')."'";
        }
        if ($this->options['encryptpwdcol']) {
            $encrypt = $this->encrypt($password);
            if (PEAR::isError($encrypt)) {
                return $encrypt;
            }
            $setval = $setval.', '.$this->options['encryptpwdcol']." = '".$encrypt."'";
        }
        $sql = 'update '.$this->options['table']." set $setval where ".$this->options['idcol']." = '".$this->id."'";

        try {
            $this->conn->query($sql);
        } catch (PDOException $e) {
            return PEAR::raiseError($e->getMessage()."($sql)", AUTO_LOGIN_ERROR);
        }

        return true;
    }

    public function deletePassword($app)
    {
    }

    public function getPwdChangedTime()
    {
    }

    public function getPwdHistory()
    {
    }

    public function getPwdLockout()
    {
    }

    public function isPwdMustChange()
    {
    }

    public function getProfiles()
    {
    }

    public function getProfileConf($tenant = null)
    {
    }

    public function getPwdPolicy($tenant = null)
    {
    }

    public function add($username, $prop)
    {
        $cols = [];
        $vals = [];
        foreach ($prop as $key => $value) {
            $value = is_array($value) ? $value[0] : $value;
            $value = $this->conn->quote($value);
            $cols[] = $key;
            $vals[] = $value;
        }
        $sql = 'insert into '.$this->options['table'].'('.$this->options['usercol'].', '.join(', ', $cols).") values('$username', ".join(', ', $vals).')';

        try {
            $this->conn->query($sql);
        } catch (PDOException $e) {
            return PEAR::raiseError($e->getMessage()."($sql)", AUTO_LOGIN_ERROR);
        }

        return true;
    }
}
