<?php

/**
 * @file
 * Token grant and renew endpoint.
 *
 * Nifty OAuth Specification based on OAuth 2.0 draft 26.
 */
$logid = 'OAuth';

//require "lib/MemcacheOAuth2.inc";
require 'lib/PDOOAuth2.inc';
require_once '/var/www/lib/util.php';

$log = &Log::singleton('syslog', LOG_LOCAL5, $logid);

// 設定ファイル取得
$conf_oauth = parse_ini_file('/var/www/conf/oauth.conf');
if (empty($conf_oauth)) {
    $log->crit(logformat("Can't read oauth.conf"));
    header('HTTP/1.1 '.'500 internal server error');
    header('Content-Type: application/json');
    header('Cache-Control: no-store');
    $result['error'] = 'system_error99';
    echo json_encode($result);
    exit();
}

$conf = $conf_oauth;
$conf['endpoint'] = 'token';

// auth_level設定
$request_uri = $_SERVER['REQUEST_URI'];
if (preg_match('/\/Oauth-middle\//', $request_uri)) {
    $conf['auth_level'] = 'middle';
} elseif (preg_match('/\/Oauth-high\//', $request_uri)) {
    $conf['auth_level'] = 'high';
}

//$oauth = new MemcacheOAuth2($conf);
$oauth = new PDOOAuth2($conf);

// 新トーケン発行
$oauth->grantAccessToken($params);
