#!/usr/bin/perl
#
#  This code was developped by SECIOSS (http://www.secioss.co.jp/).
#
#  Copyright (C) 2007 SECIOSS Corporation.
#  All rights reserved.
#

use strict;
use Encode;
use Encode::JP::H2Z;
use Data::Dumper;

require 'LISM/Utils/lism_util.pl';

sub getADStatus
{
    my ($status, $active, $inactive) = @_;

    $status = sprintf('%X', $status);
    if (substr($status, -1, 1) eq 2) {
        return $inactive;
    } else {
        return $active;
    }
}

sub strH2Z
{
    my ($str) = @_;

    if (Encode::is_utf8($str)) {
        $str = encode('utf8', $str);
    }
    Encode::from_to($str, 'utf8', 'euc-jp');
    Encode::JP::H2Z::h2z(\$str);
    Encode::from_to($str, 'euc-jp', 'utf8');

    return $str;
}

sub getParentDn
{
    my ($entryStr, $attr, $parentattr) = @_;

    my @values = ($entryStr =~ /^$attr:\:? +(.*)$/gmi);
    my ($parentrdn) = ($entryStr =~ /^$parentattr: (.*)$/mi);
    if ($parentrdn) {
        foreach my $value (@values) {
            if ($value =~ /^$parentrdn,/i) {
                return $value;
            }
        }
    }
    if (@values) {
        return $values[0];
    }

    return '';
}

1;
