#!/usr/bin/perl
#
#  This code was developped by SECIOSS (http://www.secioss.co.jp/).
#
#  Copyright (C) 2007 SECIOSS Corporation.
#  All rights reserved.
#

use strict;
use Encode;
use Encode::JP::H2Z;
use Data::Dumper;

require 'LISM/Utils/lism_util.pl';

sub getADStatus
{
    my ($status, $active, $inactive) = @_;

    $status = sprintf('%X', $status);
    if (substr($status, -1, 1) eq 2) {
        return $inactive;
    } else {
        return $active;
    }
}

sub strH2Z
{
    my ($str) = @_;

    if (Encode::is_utf8($str)) {
        $str = encode('utf8', $str);
    }
    Encode::from_to($str, 'utf8', 'euc-jp');
    Encode::JP::H2Z::h2z(\$str);
    Encode::from_to($str, 'euc-jp', 'utf8');

    return $str;
}

sub getParentDn
{
    my ($entryStr, $attr, $parentattr) = @_;

    my @values = ($entryStr =~ /^$attr:\:? +(.*)$/gmi);
    my ($parentrdn) = ($entryStr =~ /^$parentattr: (.*)$/mi);
    if ($parentrdn) {
        foreach my $value (@values) {
            if ($value =~ /^$parentrdn,/i) {
                return $value;
            }
        }
    }
    if (@values) {
        return $values[0];
    }

    return '';
}

sub setLocaleAndLang
{
    my ($line, $localeattr, $langattr, $default_locale, $check_lang) = @_;
    my ($value) = ($line =~ /^[^:]+: *(.*)$/);

    if (!$value) {
        return "$localeattr: \n$langattr: ";
    }

    my @locales = ('is_IS', 'ga_IE', 'az_AZ', 'en_US', 'ar_AE', 'es_AR', 'sc_AL', 'hy_AM', 'en_GB', 'he_IL', 'it_IT', 'en_IN', 'en_ID', 'uk_UA'
, 'es_UY', 'es_EC', 'ar_EG', 'et_EE', 'es_SV', 'en_AU', 'de_AT', 'nl_NL', 'en_GH', 'kk_KZ', 'ar_QA', 'en_CA', 'km_KH', 'el_GR', 'ky_KG', 'es_GT
', 'ar_KW', 'ka_GE', 'hr_HR', 'es_CR', 'es_CO', 'ar_SA', 'en_SG', 'fr_CH', 'sv_SE', 'es_ES', 'sk_SK', 'sl_SI', 'sr_RS', 'th_TH', 'ko_KR', 'zh_T
W', 'tg_TJ', 'cs_CZ', 'zh_CN', 'es_CL', 'da_DK', 'de_DE', 'es_DO', 'tr_TR', 'en_NG', 'ja_JP', 'en_NZ', 'no_NO', 'ar_BH', 'ur_PK', 'es_PA', 'en_
BM', 'es_PY', 'en_BB', 'hu_HU', 'en_PH', 'fi_FI', 'en_PR', 'pt_BR', 'fr_FR', 'bg_BG', 'vi_VN', 'es_VE', 'es_PE', 'fr_BE', 'pl_PL', 'bs_BA', 'pt
_PT', 'zh_HK', 'es_HN', 'zh_MO', 'mt_MT', 'ms_MY', 'en_ZA', 'es_MX', 'fr_MC', 'ro_MD', 'sr_ME', 'ar_JO', 'lv_LV', 'lt_LT', 'ro_RO', 'fr_LU', 'a
r_LB', 'ru_RU');

    my ($locale) = grep(/_$value$/i, @locales);
    if (!$locale) {
        $locale = $default_locale;
    }
    my ($lang) = ($locale =~ /^([^_]+)_/);
    my ($default_lang) = ($default_locale =~ /^([^_]+)_/);
    if ($check_lang && $lang !~ /$check_lang/i) {
        $lang = $default_lang;
    }

    return "$localeattr: $locale\n$langattr: $lang";
}

1;
