package org.seasar.extension.jdbc.impl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.types.ValueTypes;

public class ObjectResultSetHandler extends AbstractResultSetHandler {

	public ObjectResultSetHandler() {
	}

	public Object handle(ResultSet rs, DatabaseMetaData dbMetaData)
		throws SQLException {
			
		ResultSetMetaData rsmd = rs.getMetaData();
		if (rs.next()) {
			ValueType valueType = ValueTypes.getValueType(
				rsmd.getColumnType(1));
			return valueType.getValue(rs, 1);
		} else {
			return null;
		}
	}
}