/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.groovy;

import groovy.lang.GroovyShell;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.groovy.control.CompilationFailedException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerBuilder;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.groovy.SeasarBuilderException;

public class S2ContainerGroovyFactory
implements S2ContainerBuilder {
    protected S2ContainerGroovyFactory() {
    }

    public static S2Container create(String string) throws SeasarBuilderException {
        return new S2ContainerGroovyFactory().build(string);
    }

    public S2Container build(String string) throws SeasarBuilderException {
        S2Container s2Container = null;
        try {
            InputStream inputStream = ResourceUtil.getResourceAsStream((String)string);
            GroovyShell groovyShell = new GroovyShell();
            s2Container = (S2Container)groovyShell.evaluate(inputStream, string);
            if (s2Container == null) {
                throw new SeasarBuilderException("The return value is null or not returning.");
            }
            if (!(s2Container instanceof S2Container)) {
                throw new SeasarBuilderException("The return value is not instance of S2Container");
            }
        }
        catch (CompilationFailedException compilationFailedException) {
            throw new SeasarBuilderException(compilationFailedException);
        }
        catch (IOException iOException) {
            throw new SeasarBuilderException(iOException);
        }
        catch (RuntimeException runtimeException) {
            throw new SeasarBuilderException(runtimeException);
        }
        return s2Container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S2Container build(String string, ClassLoader classLoader) throws SeasarBuilderException {
        S2Container s2Container = null;
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        try {
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            s2Container = this.build(string);
            Object var6_5 = null;
            Thread.currentThread().setContextClassLoader(classLoader2);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Thread.currentThread().setContextClassLoader(classLoader2);
            throw throwable;
        }
        return s2Container;
    }
}

