/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.classgen.BytecodeHelper;

public class ArrayExpression
extends Expression {
    private String type;
    private List expressions;
    private Expression sizeExpression;

    public ArrayExpression(String type, List expressions) {
        this.type = type;
        this.expressions = expressions;
        Iterator iter = expressions.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof Expression) continue;
            throw new ClassCastException("Item: " + item + " is not an Expression");
        }
    }

    public ArrayExpression(String type, Expression sizeExpression) {
        this.type = type;
        this.sizeExpression = sizeExpression;
        this.expressions = Collections.EMPTY_LIST;
    }

    public void addExpression(Expression expression) {
        this.expressions.add(expression);
    }

    public List getExpressions() {
        return this.expressions;
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitArrayExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return new ArrayExpression(this.type, this.transformExpressions(this.expressions, transformer));
    }

    public Expression getExpression(int i) {
        Object object = this.expressions.get(i);
        return (Expression)object;
    }

    public String getType() {
        if (BytecodeHelper.isPrimitiveType(this.type)) {
            return BytecodeHelper.getObjectTypeForPrimitive(this.type);
        }
        return this.type;
    }

    public String getText() {
        StringBuffer buffer = new StringBuffer("[");
        boolean first = true;
        Iterator iter = this.expressions.iterator();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(((Expression)iter.next()).getText());
        }
        buffer.append("]");
        return buffer.toString();
    }

    public Expression getSizeExpression() {
        return this.sizeExpression;
    }

    public String toString() {
        return super.toString() + this.expressions;
    }
}

