/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilerConfiguration;

public class CompileUnit {
    private List modules = new ArrayList();
    private Map classes = new HashMap();
    private CompilerConfiguration config;
    private ClassLoader classLoader;
    private CodeSource codeSource;
    private Map cachedClasses = new HashMap();
    public static final Object NO_CLASS = new Object();

    public CompileUnit(ClassLoader classLoader, CompilerConfiguration config) {
        this(classLoader, null, config);
    }

    public CompileUnit(ClassLoader classLoader, CodeSource codeSource, CompilerConfiguration config) {
        this.classLoader = classLoader;
        this.config = config;
        this.codeSource = codeSource;
    }

    public List getModules() {
        return this.modules;
    }

    public void addModule(ModuleNode node) {
        this.modules.add(node);
        node.setUnit(this);
        this.addClasses(node.classes);
    }

    public ClassNode getClass(String name) {
        return (ClassNode)this.classes.get(name);
    }

    public List getClasses() {
        ArrayList answer = new ArrayList();
        Iterator iter = this.modules.iterator();
        while (iter.hasNext()) {
            ModuleNode module = (ModuleNode)iter.next();
            answer.addAll(module.getClasses());
        }
        return answer;
    }

    public CompilerConfiguration getConfig() {
        return this.config;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    public Class loadClass(String type) throws ClassNotFoundException {
        Object obj = this.cachedClasses.get(type);
        if (obj == NO_CLASS) {
            throw new ClassNotFoundException(type);
        }
        if (obj != null) {
            return (Class)obj;
        }
        Class<?> answer = null;
        try {
            answer = this.getClassLoader().loadClass(type);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            if (answer == null) {
                answer = Thread.currentThread().getContextClassLoader().loadClass(type);
            }
        }
        catch (ClassNotFoundException e1) {
            // empty catch block
        }
        try {
            if (answer == null) {
                answer = this.getClass().getClassLoader().loadClass(type);
            }
        }
        catch (ClassNotFoundException e2) {
            // empty catch block
        }
        try {
            if (answer == null) {
                answer = Class.forName(type);
            }
        }
        catch (ClassNotFoundException e2) {
            // empty catch block
        }
        if (answer == null) {
            this.cachedClasses.put(type, NO_CLASS);
            throw new ClassNotFoundException(type);
        }
        this.cachedClasses.put(type, answer);
        return answer;
    }

    void addClasses(List classList) {
        Iterator iter = classList.iterator();
        while (iter.hasNext()) {
            this.addClass((ClassNode)iter.next());
        }
    }

    public void addClass(ClassNode node) {
        String name = node.getName();
        if (this.classes.containsKey(name)) {
            throw new RuntimeException("Error: duplicate class declaration for name: " + name + " and class: " + node);
        }
        this.classes.put(name, node);
    }
}

