/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.security.GroovyCodeSourcePermission;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;

public class GroovyCodeSource {
    private CodeSource codeSource;
    private String name;
    private InputStream inputStream;
    Certificate[] certs;

    public GroovyCodeSource(String script, String name, String codeBase) {
        this(new ByteArrayInputStream(script.getBytes()), name, codeBase);
    }

    public GroovyCodeSource(InputStream inputStream, String name, String codeBase) {
        this.inputStream = inputStream;
        this.name = name;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new GroovyCodeSourcePermission(codeBase));
        }
        try {
            this.codeSource = new CodeSource(new URL("file", "", codeBase), null);
        }
        catch (MalformedURLException murle) {
            throw new RuntimeException("A CodeSource file URL cannot be constructed from the supplied codeBase: " + codeBase);
        }
    }

    GroovyCodeSource(InputStream inputStream, String name, final File path, final Certificate[] certs) {
        this.inputStream = inputStream;
        this.name = name;
        try {
            this.codeSource = (CodeSource)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MalformedURLException {
                    return new CodeSource(path.toURI().toURL(), certs);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException("Could not construct a URL from: " + path);
        }
    }

    public GroovyCodeSource(final File file) throws FileNotFoundException {
        this.inputStream = new FileInputStream(file);
        this.name = file.getName();
        try {
            this.codeSource = (CodeSource)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MalformedURLException {
                    return new CodeSource(file.toURI().toURL(), null);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException("Could not construct a URL from: " + file);
        }
    }

    public GroovyCodeSource(URL url) {
        this.codeSource = new CodeSource(url, null);
    }

    CodeSource getCodeSource() {
        return this.codeSource;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getName() {
        return this.name;
    }
}

