/*
 *
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyrightnotice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:
 *    "This product includes software developed by the
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements
 *    normally appear.
 *
 * 4. Neither the names "The Seasar Project" nor@the name of its
 *    contributors ay be used to endour or promote products derived
 *    from this software without specific prior written permission of
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIESOF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASER@PROJECT
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.seasar.groovy;

import java.util.List;

import junit.framework.TestCase;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;


/**
 * @author takai
 */
public class S2ContainerGroovyFactoryTest
    extends TestCase
{
    private static final String TEST_FILE =
        "org/seasar/groovy/TestFactory.groovy";

    public void testBuild() {
        S2ContainerGroovyFactory factory = new S2ContainerGroovyFactory();
        S2Container container = factory.build(TEST_FILE);

        assertNotNull(container);
        assertTrue(container.getComponent(List.class) instanceof List);
    }

    public void testBuildWithClassLoader() {
        MyLoader loader = new MyLoader(Thread.currentThread().getContextClassLoader());
        S2ContainerGroovyFactory factory = new S2ContainerGroovyFactory();

        try {
        	S2Container container = factory.build(TEST_FILE, loader);
        	fail("should be thrown NoClassDefFoundError");
        } catch (SeasarBuilderException e) {
        	assertTrue(loader.visited);
        }
    }

    public void testCreate() {
        S2Container container = S2ContainerGroovyFactory.create(TEST_FILE);
        assertNotNull(container);
        assertTrue(container.getComponent(List.class) instanceof List);

        try {
            S2Container container2 =
                S2ContainerGroovyFactory.create("no/such/File");
            fail("should be thrown SeasarBuilderException.");
        } catch (SeasarBuilderException e) {
        }

        try {
            S2Container container2 =
                S2ContainerGroovyFactory.create("org/seasar/groovy/TestFactoryEmptyFile.groovy");
            fail("should be thrown SeasarBuilderException.");
        } catch (SeasarBuilderException e) {
        }
    }
    
    public void testS2Builder(){
    	S2Container container = S2ContainerFactory.create("org/seasar/groovy/TestFactory.groovy");
        assertNotNull(container);
        assertTrue(container.getComponent(List.class) instanceof List);
    }

    class MyLoader
        extends ClassLoader
    {
        public boolean visited = false;
        
        public MyLoader(ClassLoader loader){
        	super(loader);
        }

        protected synchronized Class loadClass(String name, boolean resolve)
            throws ClassNotFoundException
        {
            if (name.equals("java.util.ArrayList")) {
                visited = true;
                throw new ClassNotFoundException();
            } else {
            	return Class.forName(name);
            }
        }
    }
}
