/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax.parser;

import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.CSTNode;
import org.codehaus.groovy.syntax.ReadException;
import org.codehaus.groovy.syntax.Reduction;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.TokenStream;
import org.codehaus.groovy.syntax.Types;
import org.codehaus.groovy.syntax.parser.ExpressionStack;
import org.codehaus.groovy.syntax.parser.ExpressionSupport;
import org.codehaus.groovy.syntax.parser.UnexpectedTokenException;

public class Parser {
    private SourceUnit controller = null;
    private TokenStream tokenStream = null;
    private int nestCount = 1;
    private static final int[] EXPRESSION_SHIFT_HANDLERS = new int[]{901, 1341, 1910, 1361, 1100, 1230, 1200, 330, 1220, 50, 10, 30, 546, 544};
    private static final int[] EXPRESSION_REDUCE_HANDLERS = new int[]{251, 261, 1235, 1100, 544, 1220};

    public Parser(SourceUnit controller, TokenStream tokenStream) {
        this.controller = controller;
        this.tokenStream = tokenStream;
    }

    public Reduction parse() throws CompilationFailedException {
        try {
            return this.module();
        }
        catch (SyntaxException e) {
            this.controller.addFatalError(new SyntaxErrorMessage(e));
            throw new GroovyBugError("this will never happen");
        }
    }

    public TokenStream getTokenStream() {
        return this.tokenStream;
    }

    public void optionalNewlines() throws SyntaxException, CompilationFailedException {
        while (this.lt(false) == 5) {
            this.consume(5);
        }
    }

    public void endOfStatement(boolean allowRightCurlyBrace) throws SyntaxException, CompilationFailedException {
        Token next = this.la(true);
        if (next.isA(1002)) {
            this.consume(true);
        } else if (allowRightCurlyBrace) {
            if (!next.isA(20)) {
                this.error(new int[]{320, 5, 20});
            }
        } else {
            this.error(new int[]{320, 5});
        }
    }

    public void endOfStatement() throws SyntaxException, CompilationFailedException {
        this.endOfStatement(true);
    }

    public CSTNode dottedIdentifier() throws SyntaxException, CompilationFailedException {
        CSTNode identifier = this.consume(440);
        while (this.lt() == 70) {
            identifier = this.consume(70).asReduction(identifier, this.consume(440));
        }
        return identifier;
    }

    public Reduction module() throws SyntaxException, CompilationFailedException {
        Reduction module = Reduction.newContainer();
        Reduction packageDeclaration = null;
        if (this.lt() == 550) {
            try {
                packageDeclaration = this.packageDeclaration();
            }
            catch (SyntaxException e) {
                this.controller.addError(e);
                this.recover();
            }
        }
        if (packageDeclaration == null) {
            packageDeclaration = Reduction.EMPTY;
        }
        module.add(packageDeclaration);
        Reduction imports = (Reduction)module.add(Reduction.newContainer());
        while (this.lt() == 551) {
            try {
                imports.add(this.importStatement());
            }
            catch (SyntaxException e) {
                this.controller.addError(e);
                this.recover();
            }
        }
        while (this.lt() != -1) {
            try {
                module.add(this.topLevelStatement());
            }
            catch (SyntaxException e) {
                this.controller.addError(e);
                this.recover();
            }
        }
        return module;
    }

    public Reduction packageDeclaration() throws SyntaxException, CompilationFailedException {
        Reduction packageDeclaration = this.consume(550).asReduction(this.dottedIdentifier());
        this.endOfStatement(false);
        return packageDeclaration;
    }

    public Reduction importStatement() throws SyntaxException, CompilationFailedException {
        Reduction importStatement = this.consume(551).asReduction();
        Reduction packageNode = null;
        if (this.lt(2) == 70) {
            packageNode = this.consume(440).asReduction();
            while (this.lt(3) == 70) {
                packageNode = this.consume(70).asReduction(packageNode);
                ((CSTNode)packageNode).add(this.consume(440));
            }
            this.consume(70);
        }
        if (packageNode == null) {
            packageNode = Reduction.EMPTY;
        }
        importStatement.add(packageNode);
        if (!((CSTNode)packageNode).isEmpty() && this.lt() == 202) {
            importStatement.add(this.consume(202));
        } else {
            boolean done = false;
            while (!done) {
                Reduction clause = this.consume(440).asReduction();
                if (this.lt() == 552) {
                    this.consume(552);
                    clause.add(this.consume(440));
                }
                importStatement.add(clause);
                if (this.lt() == 300) {
                    this.consume(300);
                    continue;
                }
                done = true;
            }
        }
        this.endOfStatement(false);
        return importStatement;
    }

    public CSTNode topLevelStatement() throws SyntaxException, CompilationFailedException {
        CSTNode result = null;
        if (this.lt() == 530) {
            this.consume();
            Reduction modifiers = this.modifierList(false, false);
            CSTNode type = this.optionalDatatype(false, true);
            Token identifier = this.nameDeclaration(false);
            result = this.methodDeclaration(modifiers, type, identifier, false);
        } else if (this.lt() == 520 && this.lt(2) == 50) {
            result = this.synchronizedStatement();
        } else if (this.la().isA(1410) || this.la().isA(1400)) {
            Reduction modifiers = this.modifierList(true, true);
            switch (this.lt()) {
                case 531: {
                    result = this.classDeclaration(modifiers);
                    break;
                }
                case 532: {
                    result = this.interfaceDeclaration(modifiers);
                    break;
                }
                default: {
                    this.error(new int[]{531, 532});
                    break;
                }
            }
        } else {
            result = this.statement();
        }
        return result;
    }

    public CSTNode typeDeclaration() throws SyntaxException, CompilationFailedException {
        return this.topLevelStatement();
    }

    public Reduction modifierList(boolean allowStatic, boolean allowAbstract) throws CompilationFailedException, SyntaxException {
        Reduction modifiers = Reduction.newContainer();
        while (this.la().isA(1410)) {
            if (this.lt() == 510 && !allowAbstract) {
                this.controller.addError("keyword 'abstract' not valid in this setting", this.la());
            } else if (this.lt() == 521 && !allowStatic) {
                this.controller.addError("keyword 'static' not valid in this setting", this.la());
            }
            modifiers.add(this.consume());
        }
        return modifiers;
    }

    public Reduction classDeclaration(Reduction modifiers) throws SyntaxException, CompilationFailedException {
        this.consume(531);
        Reduction classDeclaration = this.consume(440).asReduction(modifiers);
        classDeclaration.setMeaning(801);
        try {
            classDeclaration.add(this.typeList(541, true, 1));
        }
        catch (SyntaxException e) {
            this.controller.addError(e);
            classDeclaration.add(Reduction.EMPTY);
        }
        try {
            classDeclaration.add(this.typeList(540, true, 0));
        }
        catch (SyntaxException e) {
            this.controller.addError(e);
            classDeclaration.add(Reduction.EMPTY);
        }
        classDeclaration.add(this.typeBody(true, true, false));
        return classDeclaration;
    }

    public Reduction interfaceDeclaration(Reduction modifiers) throws SyntaxException, CompilationFailedException {
        this.consume(532);
        Reduction interfaceDeclaration = this.consume(440).asReduction(modifiers, Reduction.EMPTY);
        interfaceDeclaration.setMeaning(802);
        try {
            interfaceDeclaration.add(this.typeList(541, true, 0));
        }
        catch (SyntaxException e) {
            this.controller.addError(e);
            interfaceDeclaration.add(Reduction.EMPTY);
        }
        interfaceDeclaration.add(this.typeBody(false, true, true));
        return interfaceDeclaration;
    }

    public Reduction typeList(int declarator, boolean optional, int limit) throws SyntaxException, CompilationFailedException {
        Reduction typeList = null;
        if (this.lt() == declarator) {
            typeList = this.consume(declarator).asReduction();
            while (limit == 0 || typeList.children() < limit) {
                try {
                    if (typeList.children() > 0) {
                        this.consume(300);
                    }
                    typeList.add(this.datatype(false));
                }
                catch (SyntaxException e) {
                    this.controller.addError(e);
                    this.recover(2002);
                }
                if (this.la().isA(300)) continue;
                break;
            }
        } else if (optional) {
            typeList = Reduction.EMPTY;
        } else {
            this.error(declarator);
        }
        return typeList;
    }

    public Reduction typeBody(boolean allowStatic, boolean allowAbstract, boolean requireAbstract) throws SyntaxException, CompilationFailedException {
        Reduction body = Reduction.newContainer();
        this.consume(10);
        while (this.lt() != -1 && this.lt() != 20) {
            try {
                body.add(this.typeBodyStatement(allowStatic, allowAbstract, requireAbstract));
            }
            catch (SyntaxException e) {
                this.controller.addError(e);
                this.recover();
            }
        }
        this.consume(20);
        return body;
    }

    public Reduction typeBodyStatement(boolean allowStatic, boolean allowAbstract, boolean requireAbstract) throws SyntaxException, CompilationFailedException {
        Reduction statement = null;
        if (this.lt() == 521 && this.lt(2) == 10) {
            if (!allowStatic) {
                this.controller.addError("static initializers not valid in this context", this.la());
            }
            Reduction modifiers = this.modifierList(true, false);
            Token identifier = Token.NULL;
            statement = this.methodDeclaration(modifiers, Reduction.EMPTY, identifier, false);
        } else {
            Reduction modifiers = this.modifierList(allowStatic, allowAbstract);
            if (this.lt() == 531) {
                statement = this.classDeclaration(modifiers);
            } else if (this.lt() == 532) {
                statement = this.interfaceDeclaration(modifiers);
            } else {
                if (this.lt() == 545) {
                    this.consume();
                }
                while (this.lt(true) == 5) {
                    this.consume(5);
                }
                CSTNode type = this.optionalDatatype(true, true);
                Token identifier = this.nameDeclaration(true);
                switch (this.lt(true)) {
                    case 50: {
                        boolean methodIsAbstract = requireAbstract;
                        if (!methodIsAbstract) {
                            for (int i = 1; i < modifiers.size(); ++i) {
                                if (modifiers.get(i).getMeaning() != 510) continue;
                                methodIsAbstract = true;
                                break;
                            }
                        }
                        statement = this.methodDeclaration(modifiers, type, identifier, methodIsAbstract);
                        break;
                    }
                    case -1: 
                    case 5: 
                    case 20: 
                    case 100: 
                    case 320: {
                        statement = this.propertyDeclaration(modifiers, type, identifier);
                        break;
                    }
                    default: {
                        this.error(new int[]{50, 100, 320, 5, 20});
                    }
                }
            }
        }
        return statement;
    }

    public Reduction bodyStatement() throws SyntaxException, CompilationFailedException {
        return this.typeBodyStatement(true, true, false);
    }

    protected Token nameDeclaration(boolean significantNewlines) throws SyntaxException, CompilationFailedException {
        return this.consume(440, significantNewlines);
    }

    protected Token nameReference(boolean significantNewlines) throws SyntaxException, CompilationFailedException {
        Token token = this.la(significantNewlines);
        if (!token.canMean(440)) {
            this.error(440);
        }
        this.consume();
        token.setMeaning(440);
        return token;
    }

    protected CSTNode optionalDatatype(boolean significantNewlines, boolean allowVoid) throws SyntaxException, CompilationFailedException {
        CSTNode type = Reduction.EMPTY;
        Token next = this.la(significantNewlines);
        if (next.isA(440)) {
            if (this.lt(2, significantNewlines) == 440) {
                type = this.datatype(allowVoid);
            } else {
                this.getTokenStream().checkpoint();
                try {
                    type = this.datatype(allowVoid);
                    if (this.lt(significantNewlines) != 440) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    this.getTokenStream().restore();
                    type = Reduction.EMPTY;
                }
            }
        } else if (next.isA(1340)) {
            type = this.datatype(allowVoid);
        }
        return type;
    }

    public Reduction propertyDeclaration(Reduction modifiers, CSTNode type, Token identifier) throws SyntaxException, CompilationFailedException {
        Reduction property = identifier.asReduction(modifiers, type);
        property.setMeaning(805);
        if (this.lt() == 100) {
            this.consume();
            property.add(this.expression());
        }
        this.endOfStatement();
        return property;
    }

    public Reduction methodDeclaration(Reduction modifiers, CSTNode type, Token identifier, boolean emptyOnly) throws SyntaxException, CompilationFailedException {
        Reduction method = identifier.asReduction(modifiers, type);
        method.setMeaning(804);
        this.consume(50);
        method.add(this.parameterDeclarationList());
        this.consume(60);
        try {
            method.add(this.typeList(584, true, 0));
        }
        catch (SyntaxException e) {
            this.controller.addError(e);
            method.add(Reduction.EMPTY);
        }
        CSTNode body = null;
        if (emptyOnly) {
            if (this.lt() == 10) {
                this.controller.addError("abstract and interface methods cannot have a body", this.la());
            } else {
                body = Reduction.EMPTY;
                this.endOfStatement();
            }
        }
        if (body == null) {
            body = this.statementBody(true);
        }
        method.add(body);
        return method;
    }

    protected Reduction parameterDeclarationList() throws SyntaxException, CompilationFailedException {
        Reduction list = Reduction.newContainer();
        boolean expectDefaults = false;
        while (this.la().isA(1420)) {
            Reduction parameter = (Reduction)list.add(this.parameterDeclaration());
            if (expectDefaults || this.lt() == 100) {
                expectDefaults = true;
                this.consume(100);
                parameter.add(this.expression());
            }
            if (this.lt() != 300) break;
            this.consume(300);
        }
        return list;
    }

    protected Reduction parameterDeclaration() throws SyntaxException, CompilationFailedException {
        CSTNode type = this.optionalDatatype(false, false);
        Reduction parameter = this.nameDeclaration(false).asReduction(type);
        parameter.setMeaning(806);
        return parameter;
    }

    protected CSTNode datatype(boolean allowVoid) throws SyntaxException, CompilationFailedException {
        CSTNode datatype = this.scalarDatatype(allowVoid);
        while (this.lt(true) == 30) {
            datatype = this.consume(30).asReduction(datatype);
            this.consume(40);
        }
        return datatype;
    }

    protected CSTNode datatype() throws SyntaxException, CompilationFailedException {
        return this.datatype(true);
    }

    protected CSTNode scalarDatatype(boolean allowVoid) throws SyntaxException, CompilationFailedException {
        CSTNode datatype = null;
        datatype = this.la().isA(allowVoid ? 1340 : 1341) ? this.consume() : this.dottedIdentifier();
        return datatype;
    }

    protected CSTNode statementBody(boolean requireBraces) throws SyntaxException, CompilationFailedException {
        CSTNode body = null;
        if (this.lt() == 10) {
            Token brace = this.consume(10);
            brace.setMeaning(816);
            body = this.statementsUntilRightCurly();
            body.set(0, brace);
            this.consume(20);
        } else if (requireBraces) {
            this.error(10);
        } else {
            body = this.statement();
        }
        return body;
    }

    protected Reduction statementsUntilRightCurly() throws SyntaxException, CompilationFailedException {
        Reduction block = Reduction.newContainer();
        while (this.lt() != -1 && this.lt() != 20) {
            try {
                block.add(this.statement());
            }
            catch (SyntaxException e) {
                this.controller.addError(e);
                this.recover();
            }
        }
        return block;
    }

    protected CSTNode statement(boolean allowUnlabelledBlocks) throws SyntaxException, CompilationFailedException {
        CSTNode statement = null;
        Reduction label = null;
        if (this.lt() == 440 && this.lt(2) == 310) {
            label = this.consume(440).asReduction();
            label.setMeaning(818);
            this.consume(310);
        }
        switch (this.lt()) {
            case 585: {
                statement = this.assertStatement();
                break;
            }
            case 574: {
                statement = this.breakStatement();
                break;
            }
            case 575: {
                statement = this.continueStatement();
                break;
            }
            case 561: {
                statement = this.ifStatement();
                break;
            }
            case 560: {
                statement = this.returnStatement();
                break;
            }
            case 576: {
                statement = this.switchStatement();
                break;
            }
            case 520: {
                statement = this.synchronizedStatement();
                break;
            }
            case 583: {
                statement = this.throwStatement();
                break;
            }
            case 580: {
                statement = this.tryStatement();
                break;
            }
            case 572: {
                statement = this.forStatement();
                break;
            }
            case 570: {
                statement = this.doWhileStatement();
                break;
            }
            case 571: {
                statement = this.whileStatement();
                break;
            }
            case 320: {
                statement = this.consume().asReduction();
                statement.setMeaning(816);
                break;
            }
            case 10: {
                statement = this.expression();
                if (statement.isA(817)) {
                    if (statement.get(1).hasChildren()) break;
                    Reduction block = statement.getRoot().asReduction();
                    block.setMeaning(816);
                    block.addChildrenOf(statement.get(2));
                    if (label == null && !allowUnlabelledBlocks) {
                        this.controller.addError("groovy does not support anonymous blocks; please add a label", statement.getRoot());
                    }
                    statement = block;
                    break;
                }
                this.endOfStatement();
                break;
            }
            default: {
                try {
                    statement = this.expression();
                    this.endOfStatement();
                    break;
                }
                catch (SyntaxException e) {
                    this.controller.addError(e);
                    this.recover();
                }
            }
        }
        if (label != null) {
            ((CSTNode)label).add(statement);
            statement = label;
        }
        return statement;
    }

    protected CSTNode statement() throws SyntaxException, CompilationFailedException {
        return this.statement(false);
    }

    protected Reduction assertStatement() throws SyntaxException, CompilationFailedException {
        Reduction statement = this.consume(585).asReduction(this.expression());
        if (this.lt() == 310) {
            this.consume(310);
            statement.add(this.expression());
        }
        this.endOfStatement();
        return statement;
    }

    protected Reduction breakStatement() throws SyntaxException, CompilationFailedException {
        Reduction statement = this.consume(574).asReduction();
        if (this.lt(true) == 440) {
            statement.add(this.consume());
        }
        this.endOfStatement();
        return statement;
    }

    protected Reduction continueStatement() throws SyntaxException, CompilationFailedException {
        Reduction statement = this.consume(575).asReduction();
        if (this.lt(true) == 440) {
            statement.add(this.consume());
        }
        this.endOfStatement();
        return statement;
    }

    protected Reduction throwStatement() throws SyntaxException, CompilationFailedException {
        Reduction statement = this.consume(583).asReduction(this.expression());
        this.endOfStatement();
        return statement;
    }

    protected Reduction ifStatement() throws SyntaxException, CompilationFailedException {
        Reduction statement = this.consume(561).asReduction();
        this.consume(50);
        try {
            statement.add(this.expression());
        }
        catch (SyntaxException e) {
            this.controller.addError(e);
            this.recover(60);
        }
        this.consume(60);
        statement.add(this.statementBody(false));
        if (this.lt() == 562) {
            if (this.lt(2) == 561) {
                this.consume(562);
                statement.add(this.ifStatement());
            } else {
                Reduction last = (Reduction)statement.add(this.consume(562).asReduction());
                last.add(this.statementBody(false));
            }
        }
        return statement;
    }

    protected Reduction returnStatement() throws SyntaxException, CompilationFailedException {
        Reduction statement = this.consume(560).asReduction();
        if (!this.la(true).isA(1003)) {
            statement.add(this.expression());
        }
        this.endOfStatement();
        return statement;
    }

    protected Reduction switchStatement() throws SyntaxException, CompilationFailedException {
        Reduction statement = this.consume(576).asReduction();
        this.consume(50);
        statement.add(this.expression());
        this.consume(60);
        this.consume(10);
        boolean defaultFound = false;
        while (this.lt() == 577 || this.lt() == 578) {
            Reduction caseBlock = null;
            if (this.lt() == 577) {
                caseBlock = this.consume(577).asReduction(this.expression());
            } else if (this.lt() == 578) {
                if (defaultFound) {
                    this.controller.addError("duplicate default entry in switch", this.la());
                }
                caseBlock = this.consume(578).asReduction();
                defaultFound = true;
            } else {
                this.error(new int[]{578, 577});
                this.recover(2005);
            }
            this.consume(310);
            boolean first = true;
            while (!this.la().isA(2004)) {
                caseBlock.add(this.statement(first));
                first = false;
            }
            statement.add(caseBlock);
        }
        this.consume(20);
        return statement;
    }

    protected Reduction synchronizedStatement() throws SyntaxException, CompilationFailedException {
        Reduction statement = this.consume(520).asReduction();
        this.consume(50);
        statement.add(this.expression());
        this.consume(60);
        statement.add(this.statementBody(true));
        return statement;
    }

    protected Reduction tryStatement() throws SyntaxException, CompilationFailedException {
        Reduction statement = this.consume(580).asReduction();
        statement.add(this.statementBody(true));
        Reduction catches = (Reduction)statement.add(Reduction.newContainer());
        while (this.lt() == 581) {
            try {
                Reduction catchBlock = (Reduction)catches.add(this.consume(581).asReduction());
                this.consume(50);
                try {
                    catchBlock.add(this.datatype(false));
                    catchBlock.add(this.nameDeclaration(false));
                }
                catch (SyntaxException e) {
                    this.controller.addError(e);
                    this.recover(60);
                }
                this.consume(60);
                catchBlock.add(this.statementBody(true));
            }
            catch (SyntaxException e) {
                this.controller.addError(e);
                this.recover();
            }
        }
        if (this.lt() == 582) {
            this.consume(582);
            statement.add(this.statementBody(true));
        } else {
            statement.add(Reduction.EMPTY);
        }
        return statement;
    }

    protected Reduction forStatement() throws SyntaxException, CompilationFailedException {
        Reduction statement = this.consume(572).asReduction();
        this.consume(50);
        this.getTokenStream().checkpoint();
        Reduction header = null;
        CSTNode datatype = this.optionalDatatype(false, false);
        if (this.lt(2) == 573 || this.lt(2) == 310) {
            Token name = this.nameDeclaration(false);
            header = this.consume().asReduction(datatype, name, this.expression());
        } else {
            this.getTokenStream().restore();
            header = Reduction.newContainer();
            Reduction init = Reduction.newContainer();
            while (this.lt() != 320 && this.lt() != -1) {
                init.add(this.expression());
                if (this.lt() == 320) continue;
                this.consume(300);
            }
            this.consume(320);
            header.add(init);
            header.add(this.expression());
            this.consume(320);
            Reduction incr = (Reduction)header.add(Reduction.newContainer());
            while (this.lt() != 60 && this.lt() != -1) {
                incr.add(this.expression());
                if (this.lt() == 60) continue;
                this.consume(300);
            }
        }
        this.consume(60);
        statement.add(header);
        statement.add(this.statementBody(false));
        return statement;
    }

    protected Reduction doWhileStatement() throws SyntaxException, CompilationFailedException {
        Reduction statement = this.consume(570).asReduction();
        statement.add(this.statementBody(false));
        this.consume(571);
        this.consume(50);
        try {
            statement.add(this.expression());
        }
        catch (SyntaxException e) {
            this.controller.addError(e);
            this.recover(60);
        }
        this.consume(60);
        return statement;
    }

    protected Reduction whileStatement() throws SyntaxException, CompilationFailedException {
        Reduction statement = this.consume(571).asReduction();
        this.consume(50);
        try {
            statement.add(this.expression());
        }
        catch (SyntaxException e) {
            this.controller.addError(e);
            this.recover(60);
        }
        this.consume(60);
        statement.add(this.statementBody(false));
        return statement;
    }

    protected CSTNode expression() throws SyntaxException, CompilationFailedException {
        ExpressionStack stack = new ExpressionStack(this);
        CSTNode expression = null;
        boolean bareMode = false;
        block26: while (true) {
            Token next = this.la(stack);
            int type = next.getMeaningAs(EXPRESSION_SHIFT_HANDLERS);
            switch (type) {
                case 901: {
                    if (stack.topIsAnExpression()) {
                        this.error("gstring cannot directly follow another expression");
                    }
                    stack.push(this.gstring());
                    break;
                }
                case 1341: {
                    stack.shiftIf(stack.atStartOfExpression(), "type name not valid in this context");
                    break;
                }
                case 1910: {
                    stack.shiftUnlessTopIsAnExpression("literal cannot directly follow another expression");
                    break;
                }
                case 1361: {
                    if (stack.top().isA(1106) && stack.topIsAnOperator()) {
                        this.la().setMeaning(440);
                        stack.shift();
                        break;
                    }
                    this.error("not valid as an identifier in this context");
                    break;
                }
                case 1100: {
                    stack.shiftIf(stack.topIsAModifiableExpression(), "left-hand-side of assignment must be modifiable");
                    break;
                }
                case 1230: {
                    if (stack.topIsAnOperator(0, true)) {
                        Types.makePrefix(next, false);
                    }
                    stack.shift();
                    break;
                }
                case 1200: {
                    Types.makePrefix(next, false);
                    stack.shift();
                    break;
                }
                case 330: 
                case 1220: {
                    stack.shiftIfTopIsAnExpression("infix operators may only follow expressions");
                    break;
                }
                case 50: {
                    boolean condition = stack.atStartOfExpression() || stack.topIsAnOperator() && !stack.top().isA(1106);
                    stack.shiftIf(condition, "sub-expression not valid at this position");
                    break;
                }
                case 10: {
                    if (stack.atStartOfExpression() || stack.topIsAnOperator() || stack.top().isA(814)) {
                        stack.push(this.closureExpression());
                        break;
                    }
                    this.error("closure not valid in this context");
                    break;
                }
                case 30: {
                    boolean isMap = false;
                    boolean insist = false;
                    if (stack.topIsAnExpression()) {
                        insist = true;
                    }
                    stack.push(this.listOrMapExpression(isMap, insist));
                    break;
                }
                case 546: {
                    if (stack.atStartOfExpression() || stack.topIsAnOperator()) {
                        stack.push(this.newExpression());
                        break;
                    }
                    this.error("new can follow the start of an expression or another operator");
                    break;
                }
                case 544: {
                    stack.shiftIf(stack.topIsAnExpression(), "instanceof may only follow an expression");
                    break;
                }
                default: {
                    if (stack.size() == 1 && stack.topIsAnExpression()) break block26;
                    this.error();
                }
            }
            boolean checkAgain = false;
            boolean skipPatterns = false;
            CSTNode top0 = null;
            CSTNode top1 = null;
            CSTNode top2 = null;
            int nextPrecedence = 0;
            int top1Precedence = 0;
            block27: do {
                if (!stack.topIsAnExpression() && !ExpressionSupport.isAPotentialTypeName(stack.top(), false)) continue block26;
                checkAgain = false;
                skipPatterns = false;
                top0 = stack.top();
                top1 = stack.top(1);
                top2 = stack.top(2);
                next = this.la(stack);
                nextPrecedence = Types.getPrecedence(next.getMeaning(), false);
                top1Precedence = Types.getPrecedence(top1.getMeaning(), false);
                if (top1.isA(50)) {
                    if (next.isA(60)) {
                        boolean castPrecluded;
                        this.consume();
                        next = this.la(true);
                        boolean bl = castPrecluded = next.isA(5) || next.isA(2008);
                        if (ExpressionSupport.isAPotentialTypeName(top0, false) && !castPrecluded) {
                            CSTNode name = stack.pop();
                            Reduction cast = ((Token)stack.pop()).asReduction(name);
                            cast.setMeaning(815);
                            stack.push(cast);
                        } else {
                            CSTNode subexpression = stack.pop();
                            stack.pop();
                            stack.push(subexpression);
                        }
                        checkAgain = true;
                        continue;
                    }
                    skipPatterns = true;
                }
                if (top0.isA(546) && !top0.isAnExpression()) {
                    top0.markAsExpression();
                    if (top1.isA(70)) {
                        CSTNode theNew = stack.pop();
                        CSTNode theDot = stack.pop();
                        CSTNode context = stack.pop();
                        theNew.set(1, context);
                        stack.push(theNew);
                        checkAgain = true;
                        continue;
                    }
                }
                if (top1.isA(1106) && !top0.hasChildren()) {
                    stack.reduce(3, 1, true);
                    checkAgain = true;
                    continue;
                }
                if (top0.isA(810) && top1.isAnExpression() || ExpressionSupport.isAPotentialTypeName(top1, false)) {
                    if (!top0.hasChildren()) {
                        boolean classReference;
                        boolean typePreceeds = ExpressionSupport.isAPotentialTypeName(top1, false);
                        boolean potentialCast = top2.isA(50);
                        boolean potentialDecl = top2.isA(50) || top2.isA(0);
                        boolean bl = classReference = next.isA(70) && this.la(2).isA(531);
                        if (!typePreceeds || !potentialCast && !potentialDecl && !classReference) {
                            this.error("empty square brackets are only valid on type names");
                        }
                        Reduction array = stack.pop().asReduction();
                        array.setMeaning(30);
                        array.add(stack.pop());
                        while (this.lt(true) == 30) {
                            array = this.consume(30).asReduction(array);
                            this.consume(40);
                        }
                        if (classReference) {
                            Reduction reference = this.consume(70).asReduction(array, this.consume(531));
                            ((CSTNode)reference).markAsExpression();
                            stack.push(reference);
                        } else if (this.lt(true) == 440 && this.lt(2) == 100) {
                            stack.push(this.variableDeclarationExpression(array));
                        } else if (stack.top().isA(50) && this.la(true).isA(60)) {
                            Reduction cast = ((Token)stack.pop()).asReduction(array);
                            cast.setMeaning(815);
                            stack.push(cast);
                            this.consume(60);
                        } else {
                            this.error("found array type where none expected");
                        }
                    } else {
                        CSTNode list = stack.pop();
                        CSTNode base = stack.pop();
                        Reduction result = ((Token)list.get(0)).dup().asReduction();
                        result.setMeaning(30);
                        result.add(base);
                        if (list.children() == 1) {
                            result.add(list.get(1));
                        } else {
                            result.add(list);
                        }
                        result.markAsExpression();
                        stack.push(result);
                    }
                    checkAgain = true;
                    continue;
                }
                if (this.la(true).isA(440) && this.lt(2) == 100 && ExpressionSupport.isAPotentialTypeName(top0, false)) {
                    stack.push(this.variableDeclarationExpression(stack.pop()));
                    checkAgain = true;
                    continue;
                }
                if (top1.isA(814) && top0.isA(817)) {
                    CSTNode parameters = top1.get(2);
                    int last = parameters.size() - 1;
                    if (last > 0 && parameters.get(last).isA(817)) {
                        this.error("you may only pass one closure to a method implicitly");
                    }
                    parameters.add(stack.pop());
                    checkAgain = true;
                    continue;
                }
                if (ExpressionSupport.isInvokable(top0) && (next.isA(10) || this.la(true).isA(2006))) {
                    CSTNode name = stack.pop();
                    Reduction method = null;
                    switch (next.getMeaning()) {
                        case 50: {
                            method = this.consume().asReduction();
                            method.add(name);
                            method.add(this.la().isA(60) ? Reduction.newContainer() : this.parameterList());
                            this.consume(60);
                            break;
                        }
                        case 10: {
                            method = Token.newSymbol(50, next.getStartLine(), next.getStartColumn()).asReduction();
                            method.add(name);
                            method.add(Reduction.newContainer());
                            break;
                        }
                        default: {
                            method = Token.newSymbol(50, next.getStartLine(), next.getStartColumn()).asReduction();
                            method.add(name);
                            method.add(this.parameterList());
                        }
                    }
                    method.setMeaning(814);
                    method.markAsExpression();
                    stack.push(method);
                    if (this.lt() == 10) continue;
                    checkAgain = true;
                    continue;
                }
                if (next.isA(1210) && stack.topIsAnExpression()) {
                    if (!ExpressionSupport.isAVariable(stack.top())) {
                        this.error("increment/decrement operators can only be applied to variables");
                    }
                    Types.makePostfix(next, true);
                    stack.shift();
                    stack.reduce(2, 0, true);
                    checkAgain = true;
                    continue;
                }
                if (top1.isA(330)) {
                    boolean reduce = false;
                    if (this.la().isA(310)) {
                        if (top1.hasChildren()) {
                            this.error("ternary operator can have only three clauses");
                        }
                        this.consume();
                        stack.reduce(3, 1, false);
                        checkAgain = true;
                        continue;
                    }
                    if (Types.getPrecedence(next.getMeaning(), false) >= 10) continue;
                    stack.reduce(2, 1, false);
                    stack.top().setMeaning(819);
                    checkAgain = true;
                    continue;
                }
                if (skipPatterns || !ExpressionSupport.isAnOperator(top1, false)) continue block26;
                switch (top1.getMeaningAs(EXPRESSION_REDUCE_HANDLERS)) {
                    case 251: 
                    case 261: {
                        if (nextPrecedence >= top1Precedence) continue block27;
                        if (!ExpressionSupport.isAVariable(stack.top())) {
                            this.error("increment/decrement operators can only be applied to variables");
                        }
                        stack.reduce(2, 1, true);
                        checkAgain = true;
                        break;
                    }
                    case 1235: {
                        if (nextPrecedence >= top1Precedence) continue block27;
                        stack.reduce(2, 1, true);
                        checkAgain = true;
                        break;
                    }
                    case 1100: {
                        if (nextPrecedence >= top1Precedence) continue block27;
                        stack.reduce(3, 1, true);
                        checkAgain = true;
                        break;
                    }
                    case 544: {
                        if (nextPrecedence >= top1Precedence) continue block27;
                        if (!ExpressionSupport.isAPotentialTypeName(top0, false)) {
                            this.error("instanceof right-hand side must be a valid type name");
                        }
                        stack.reduce(3, 1, true);
                        checkAgain = true;
                        break;
                    }
                    case 1220: {
                        if (nextPrecedence > top1Precedence) continue block27;
                        stack.reduce(3, 1, true);
                        checkAgain = true;
                        break;
                    }
                    default: {
                        throw new GroovyBugError("found unexpected token during REDUCE [" + top1.getMeaning() + "]");
                    }
                }
            } while (checkAgain);
        }
        if (stack.size() == 1 && stack.topIsAnExpression()) {
            expression = stack.pop();
        } else {
            this.error("expression incomplete");
        }
        return expression;
    }

    protected Reduction variableDeclarationExpression(CSTNode datatype) throws SyntaxException, CompilationFailedException {
        Reduction expression = ((Token)datatype.get(0)).dup().asReduction(datatype);
        expression.setMeaning(830);
        boolean done = false;
        do {
            try {
                Reduction declaration = (Reduction)expression.add(this.nameDeclaration(false).asReduction());
                this.consume(100);
                declaration.add(this.expression());
            }
            catch (SyntaxException e) {
                this.controller.addError(e);
                this.recover(1003);
            }
            if (this.lt() == 300) {
                this.consume(300);
                continue;
            }
            done = true;
        } while (!done);
        return expression;
    }

    protected Reduction gstring() throws SyntaxException, CompilationFailedException {
        Reduction data = Reduction.newContainer();
        this.consume(901);
        block4: while (this.lt() != 902 && this.lt() != -1) {
            switch (this.lt()) {
                case 400: {
                    data.add(this.consume());
                    continue block4;
                }
                case 903: {
                    this.consume();
                    data.add(this.expression());
                    this.consume(904);
                    continue block4;
                }
            }
            throw new GroovyBugError("gstring found invalid token: " + this.la());
        }
        Reduction complete = this.consume(902).asReduction();
        complete.addChildrenOf(data);
        complete.setMeaning(812);
        return complete;
    }

    protected Reduction parameterList() throws SyntaxException, CompilationFailedException {
        Reduction list = Reduction.newContainer();
        Reduction named = null;
        boolean done = false;
        do {
            if (this.la().canMean(440) && this.la(2).isA(310)) {
                if (named == null) {
                    named = Token.newPlaceholder(811).asReduction();
                    list.add(named);
                }
                Token name = this.nameReference(false);
                name.setMeaning(400);
                named.add(this.consume(310).asReduction(name, this.expression()));
            } else {
                list.add(this.expression());
            }
            if (this.lt() == 300) {
                this.consume();
                continue;
            }
            done = true;
        } while (!done);
        return list;
    }

    protected Reduction newExpression() throws SyntaxException, CompilationFailedException {
        Reduction expression = this.consume(546).asReduction();
        CSTNode scalarType = this.scalarDatatype(false);
        if (this.lt(true) == 30) {
            boolean implicit = this.lt(2) == 40;
            Reduction dimensions = implicit ? Reduction.EMPTY : Reduction.newContainer();
            int count = 0;
            CSTNode arrayType = scalarType;
            while (this.lt(true) == 30) {
                arrayType = this.consume(30).asReduction(arrayType);
                ++count;
                if (!implicit) {
                    dimensions.add(this.expression());
                }
                this.consume(40);
            }
            expression.add(arrayType);
            expression.add(dimensions);
            if (implicit) {
                expression.add(this.tupleExpression(0, count));
            }
        } else {
            expression.add(scalarType);
            Reduction parameters = null;
            this.consume(50);
            parameters = this.lt() == 60 ? Reduction.newContainer() : this.parameterList();
            this.consume(60);
            expression.add(parameters);
            if (this.lt() == 10) {
                if (this.lt(2) == 340 || this.lt(2) == 162) {
                    parameters.add(this.closureExpression());
                } else {
                    expression.add(this.typeBody(true, false, false));
                }
            }
        }
        return expression;
    }

    protected Reduction tupleExpression(int level, int depth) throws SyntaxException, CompilationFailedException {
        Reduction data = this.consume(10).asReduction();
        data.setMeaning(820);
        if (this.lt() != 20) {
            int child = level + 1;
            boolean leaf = child == depth;
            do {
                data.add(leaf ? this.expression() : this.tupleExpression(child, depth));
            } while (this.lt() == 300 && this.consume() != null);
        }
        this.consume(20);
        return data;
    }

    protected Reduction closureExpression() throws SyntaxException, CompilationFailedException {
        boolean specified;
        Reduction closure = this.consume(10).asReduction();
        closure.setMeaning(817);
        boolean bl = specified = this.lt() == 340 || this.lt() == 162;
        if (!specified) {
            this.getTokenStream().checkpoint();
            CSTNode type = this.optionalDatatype(true, false);
            if (this.lt() == 440 && (this.lt(2) == 340 || this.lt(2) == 300)) {
                specified = true;
            }
            this.getTokenStream().restore();
        }
        if (specified) {
            if (this.lt() == 162) {
                this.consume(162);
                closure.add(Reduction.newContainer());
            } else {
                if (this.lt() == 340) {
                    this.consume(340);
                }
                closure.add(this.parameterDeclarationList());
                this.consume(340);
            }
        } else {
            closure.add(Reduction.newContainer());
        }
        closure.add(this.statementsUntilRightCurly());
        this.consume(20);
        return closure;
    }

    protected Reduction listOrMapExpression(boolean isMap, boolean insist) throws SyntaxException, CompilationFailedException {
        boolean done;
        Reduction expression = this.consume(30).asReduction();
        expression.setMeaning(810);
        if (this.lt() == 310) {
            if (!isMap && insist) {
                this.error("expected list");
            }
            isMap = true;
            expression.setMeaning(811);
            this.consume();
            if (this.lt() != 40) {
                this.error("expected empty map");
            }
        }
        boolean bl = done = this.lt() == 40;
        while (!done) {
            CSTNode element = this.expression();
            if (!insist) {
                insist = true;
                if (this.lt() == 310) {
                    isMap = true;
                    expression.setMeaning(811);
                }
            }
            if (isMap) {
                element = this.consume(310).asReduction(element, this.expression());
            }
            expression.add(element);
            if (this.lt() == 300) {
                this.consume();
                continue;
            }
            done = true;
        }
        this.consume(40);
        return expression;
    }

    protected Reduction listOrMapExpression() throws SyntaxException, CompilationFailedException {
        return this.listOrMapExpression(false, false);
    }

    protected UnexpectedTokenException error(Token found, int[] expectedTypes, boolean throwIt, String comment) throws SyntaxException {
        UnexpectedTokenException e = new UnexpectedTokenException(found, expectedTypes, comment);
        if (throwIt) {
            throw e;
        }
        return e;
    }

    protected UnexpectedTokenException error(int[] expectedTypes, boolean throwIt, int k, String comment) throws SyntaxException, CompilationFailedException {
        return this.error(this.la(k), expectedTypes, throwIt, comment);
    }

    protected UnexpectedTokenException error(int[] expectedTypes, boolean throwIt, int k) throws SyntaxException, CompilationFailedException {
        return this.error(expectedTypes, throwIt, k, null);
    }

    protected void error(int[] expectedTypes) throws SyntaxException, CompilationFailedException {
        throw this.error(expectedTypes, false, 1, null);
    }

    protected void error() throws SyntaxException, CompilationFailedException {
        throw this.error(null, true, 1, null);
    }

    protected void error(String comment) throws SyntaxException, CompilationFailedException {
        throw this.error(null, true, 1, comment);
    }

    protected void error(Token found, String comment) throws SyntaxException {
        throw this.error(found, null, true, comment);
    }

    protected void error(int expectedType) throws SyntaxException, CompilationFailedException {
        this.error(new int[]{expectedType});
    }

    public void recover(int[] safe, boolean ignoreNewlines) throws SyntaxException, CompilationFailedException {
        Token next;
        Token leading = this.la(ignoreNewlines);
        while (!(next = this.la(ignoreNewlines)).isA(-1) && !next.isOneOf(safe)) {
            this.consume(ignoreNewlines);
        }
        if (this.la(ignoreNewlines) == leading) {
            this.consume(ignoreNewlines);
        }
    }

    public void recover(int safe, boolean ignoreNewlines) throws SyntaxException, CompilationFailedException {
        Token next;
        Token leading = this.la(ignoreNewlines);
        while (!(next = this.la(ignoreNewlines)).isA(-1) && !next.isA(safe)) {
            this.consume(ignoreNewlines);
        }
        if (this.la(ignoreNewlines) == leading) {
            this.consume(ignoreNewlines);
        }
    }

    public void recover(int[] safe) throws SyntaxException, CompilationFailedException {
        this.recover(safe, false);
    }

    public void recover(int safe) throws SyntaxException, CompilationFailedException {
        this.recover(safe, false);
    }

    public void recover() throws SyntaxException, CompilationFailedException {
        this.recover(1003, true);
    }

    protected Token la(int k, boolean significantNewlines) throws SyntaxException, CompilationFailedException {
        Token token = Token.NULL;
        try {
            int streamK = 1;
            while (k > 0 && token.getMeaning() != -1) {
                token = this.getTokenStream().la(streamK);
                ++streamK;
                if (token == null) {
                    token = Token.EOF;
                    continue;
                }
                if (token.getMeaning() == 5) {
                    if (!significantNewlines) continue;
                    --k;
                    continue;
                }
                --k;
            }
        }
        catch (ReadException e) {
            this.controller.addFatalError(new SimpleMessage(e.getMessage()));
        }
        return token;
    }

    protected Token la(int k) throws SyntaxException, CompilationFailedException {
        return this.la(k, false);
    }

    protected Token la(boolean significantNewlines) throws SyntaxException, CompilationFailedException {
        return this.la(1, significantNewlines);
    }

    protected Token la() throws SyntaxException, CompilationFailedException {
        return this.la(1, false);
    }

    protected Token la(ExpressionStack stack) throws SyntaxException, CompilationFailedException {
        Token next = this.la();
        if (stack.canComplete() && next.isA(2007) && this.la(true).getMeaning() == 5) {
            next = this.la(true);
        }
        return next;
    }

    protected int lt(int k, boolean significantNewlines) throws SyntaxException, CompilationFailedException {
        return this.la(k, significantNewlines).getMeaning();
    }

    protected int lt(int k) throws SyntaxException, CompilationFailedException {
        return this.la(k).getMeaning();
    }

    protected int lt(boolean significantNewlines) throws SyntaxException, CompilationFailedException {
        return this.la(significantNewlines).getMeaning();
    }

    protected int lt() throws SyntaxException, CompilationFailedException {
        return this.la().getMeaning();
    }

    protected Token consume(int type, boolean significantNewlines) throws SyntaxException, CompilationFailedException {
        try {
            if (!this.la(significantNewlines).isA(type)) {
                this.error(type);
            }
            if (!significantNewlines) {
                while (this.lt(true) == 5) {
                    this.getTokenStream().consume(5);
                }
            }
            return this.getTokenStream().consume(type);
        }
        catch (ReadException e) {
            this.controller.addFatalError(new SimpleMessage(e.getMessage()));
            throw new GroovyBugError("this should never happen");
        }
    }

    protected Token consume(int type) throws SyntaxException, CompilationFailedException {
        return this.consume(type, type == 5);
    }

    protected Token consume() throws SyntaxException, CompilationFailedException {
        return this.consume(this.lt(), false);
    }

    protected Token consume(boolean significantNewlines) throws SyntaxException, CompilationFailedException {
        return this.consume(this.lt(significantNewlines), significantNewlines);
    }
}

