/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import org.codehaus.groovy.ast.Parameter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Constants;

public class BytecodeHelper
implements Constants {
    private CodeVisitor cv;

    public BytecodeHelper(CodeVisitor cv) {
        this.cv = cv;
    }

    public void box(Class type) {
        if (type.isPrimitive() && type != Void.TYPE) {
            String returnString = "(" + BytecodeHelper.getTypeDescription(type.getName()) + ")Ljava/lang/Object;";
            this.cv.visitMethodInsn(184, "org/codehaus/groovy/runtime/InvokerHelper", "box", returnString);
        }
    }

    public void box(String type) {
        if (BytecodeHelper.isPrimitiveType(type) && !type.equals("void")) {
            String returnString = "(" + BytecodeHelper.getTypeDescription(type) + ")Ljava/lang/Object;";
            this.cv.visitMethodInsn(184, "org/codehaus/groovy/runtime/InvokerHelper", "box", returnString);
        }
    }

    public void unbox(Class type) {
        if (type.isPrimitive() && type != Void.TYPE) {
            String returnString = "(Ljava/lang/Object;)" + BytecodeHelper.getTypeDescription(type.getName());
            this.cv.visitMethodInsn(184, "org/codehaus/groovy/runtime/InvokerHelper", type.getName() + "Unbox", returnString);
        }
    }

    public void unbox(String type) {
        if (BytecodeHelper.isPrimitiveType(type) && !type.equals("void")) {
            String returnString = "(Ljava/lang/Object;)" + BytecodeHelper.getTypeDescription(type);
            this.cv.visitMethodInsn(184, "org/codehaus/groovy/runtime/InvokerHelper", type + "Unbox", returnString);
        }
    }

    public static boolean isPrimitiveType(String type) {
        return type != null && (type.equals("boolean") || type.equals("byte") || type.equals("char") || type.equals("short") || type.equals("int") || type.equals("long") || type.equals("float") || type.equals("double"));
    }

    public static String getTypeDescription(String name) {
        if (name == null) {
            return "Ljava/lang/Object;";
        }
        if (name.equals("void")) {
            return "V";
        }
        String prefix = "";
        if (name.endsWith("[]")) {
            prefix = "[";
            name = name.substring(0, name.length() - 2);
        }
        if (name.equals("int")) {
            return prefix + "I";
        }
        if (name.equals("long")) {
            return prefix + "J";
        }
        if (name.equals("short")) {
            return prefix + "S";
        }
        if (name.equals("float")) {
            return prefix + "F";
        }
        if (name.equals("double")) {
            return prefix + "D";
        }
        if (name.equals("byte")) {
            return prefix + "B";
        }
        if (name.equals("char")) {
            return prefix + "C";
        }
        if (name.equals("boolean")) {
            return prefix + "Z";
        }
        return prefix + "L" + name.replace('.', '/') + ";";
    }

    protected static String getClassInternalName(String name) {
        if (name == null) {
            return "java/lang/Object";
        }
        String answer = name.replace('.', '/');
        if (answer.endsWith("[]")) {
            return "[" + answer.substring(0, answer.length() - 2);
        }
        return answer;
    }

    protected static String getMethodDescriptor(String returnTypeName, Parameter[] paramTypeNames) {
        StringBuffer buffer = new StringBuffer("(");
        for (int i = 0; i < paramTypeNames.length; ++i) {
            buffer.append(BytecodeHelper.getTypeDescription(paramTypeNames[i].getType()));
        }
        buffer.append(")");
        buffer.append(BytecodeHelper.getTypeDescription(returnTypeName));
        return buffer.toString();
    }

    protected static String getMethodDescriptor(Class returnType, Class[] paramTypes) {
        StringBuffer buffer = new StringBuffer("(");
        for (int i = 0; i < paramTypes.length; ++i) {
            buffer.append(BytecodeHelper.getTypeDescription(paramTypes[i]));
        }
        buffer.append(")");
        buffer.append(BytecodeHelper.getTypeDescription(returnType));
        return buffer.toString();
    }

    public static String getTypeDescription(Class type) {
        if (type.isArray()) {
            return type.getName().replace('.', '/');
        }
        return BytecodeHelper.getTypeDescription(type.getName());
    }

    protected static String[] getClassInternalNames(String[] names) {
        int size = names.length;
        String[] answer = new String[size];
        for (int i = 0; i < size; ++i) {
            answer[i] = BytecodeHelper.getClassInternalName(names[i]);
        }
        return answer;
    }

    protected void pushConstant(boolean value) {
        if (value) {
            this.cv.visitInsn(4);
        } else {
            this.cv.visitInsn(3);
        }
    }

    protected void pushConstant(int value) {
        switch (value) {
            case 0: {
                this.cv.visitInsn(3);
                break;
            }
            case 1: {
                this.cv.visitInsn(4);
                break;
            }
            case 2: {
                this.cv.visitInsn(5);
                break;
            }
            case 3: {
                this.cv.visitInsn(6);
                break;
            }
            case 4: {
                this.cv.visitInsn(7);
                break;
            }
            case 5: {
                this.cv.visitInsn(8);
                break;
            }
            default: {
                if (value >= -128 && value <= 127) {
                    this.cv.visitIntInsn(16, value);
                    break;
                }
                if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
                    this.cv.visitIntInsn(17, value);
                    break;
                }
                this.cv.visitLdcInsn((Object)new Integer(value));
            }
        }
    }

    public void doCast(String type) {
        if (!type.equals("java.lang.Object")) {
            if (BytecodeHelper.isPrimitiveType(type) && !type.equals("void")) {
                this.unbox(type);
            } else {
                this.cv.visitTypeInsn(192, type.endsWith("[]") ? BytecodeHelper.getTypeDescription(type) : BytecodeHelper.getClassInternalName(type));
            }
        }
    }

    public void doCast(Class type) {
        String name = type.getName();
        if (type.isArray()) {
            name = type.getComponentType().getName() + "[]";
        }
        this.doCast(name);
    }

    public void load(String type, int idx) {
        if (type.equals("double")) {
            this.cv.visitVarInsn(24, idx);
        } else if (type.equals("float")) {
            this.cv.visitVarInsn(23, idx);
        } else if (type.equals("long")) {
            this.cv.visitVarInsn(22, idx);
        } else if (type.equals("boolean") || type.equals("char") || type.equals("byte") || type.equals("int") || type.equals("short")) {
            this.cv.visitVarInsn(21, idx);
        } else {
            this.cv.visitVarInsn(25, idx);
        }
    }

    public void store(String type, int idx) {
        if (type.equals("double")) {
            this.cv.visitVarInsn(57, idx);
        } else if (type.equals("float")) {
            this.cv.visitVarInsn(56, idx);
        } else if (type.equals("long")) {
            this.cv.visitVarInsn(55, idx);
        } else if (type.equals("boolean") || type.equals("char") || type.equals("byte") || type.equals("int") || type.equals("short")) {
            this.cv.visitVarInsn(54, idx);
        } else {
            this.cv.visitVarInsn(58, idx);
        }
    }

    public static String getObjectTypeForPrimitive(String type) {
        if (type.equals("boolean")) {
            return Boolean.class.getName();
        }
        if (type.equals("byte")) {
            return Byte.class.getName();
        }
        if (type.equals("char")) {
            return Character.class.getName();
        }
        if (type.equals("short")) {
            return Short.class.getName();
        }
        if (type.equals("int")) {
            return Integer.class.getName();
        }
        if (type.equals("long")) {
            return Long.class.getName();
        }
        if (type.equals("float")) {
            return Float.class.getName();
        }
        if (type.equals("double")) {
            return Double.class.getName();
        }
        return null;
    }
}

