/*
 * Decompiled with CFR 0.152.
 */
package groovy.text;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import groovy.text.Template;
import groovy.text.TemplateEngine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.runtime.InvokerHelper;

public class SimpleTemplateEngine
extends TemplateEngine {
    public Template createTemplate(Reader reader) throws CompilationFailedException, ClassNotFoundException, IOException {
        SimpleTemplate template = new SimpleTemplate();
        GroovyShell shell = new GroovyShell();
        String script = template.parse(reader);
        template.script = shell.parse(script);
        return template;
    }

    private static class SimpleTemplate
    implements Template {
        private Script script;
        private Binding binding;
        private Map map;

        private SimpleTemplate() {
        }

        public void setBinding(Map map) {
            this.map = map;
            this.binding = new Binding(map);
        }

        public Writer writeTo(Writer writer) throws IOException {
            if (this.binding == null) {
                this.binding = new Binding();
            }
            Script scriptObject = InvokerHelper.createScript(this.script.getClass(), this.binding);
            PrintWriter pw = new PrintWriter(writer);
            scriptObject.setProperty("out", pw);
            scriptObject.run();
            pw.flush();
            return writer;
        }

        public String toString() {
            try {
                StringWriter sw = new StringWriter();
                this.writeTo(sw);
                return sw.toString();
            }
            catch (Exception e) {
                return e.toString();
            }
        }

        private String parse(Reader reader) throws IOException {
            int c;
            if (!reader.markSupported()) {
                reader = new BufferedReader(reader);
            }
            StringWriter sw = new StringWriter();
            this.startScript(sw);
            boolean start = false;
            while ((c = reader.read()) != -1) {
                if (c == 60) {
                    c = reader.read();
                    if (c != 37) {
                        sw.write(60);
                    } else {
                        reader.mark(1);
                        c = reader.read();
                        if (c == 61) {
                            this.groovyExpression(reader, sw);
                            continue;
                        }
                        reader.reset();
                        this.groovySection(reader, sw);
                        continue;
                    }
                }
                if (c == 34) {
                    sw.write(92);
                }
                sw.write(c);
            }
            this.endScript(sw);
            String result = sw.toString();
            return result;
        }

        private void startScript(StringWriter sw) {
            sw.write("/* Generated by SimpleTemplateEngine */ ");
            sw.write("out.print(\"");
        }

        private void endScript(StringWriter sw) {
            sw.write("\");\n");
        }

        private void groovyExpression(Reader reader, StringWriter sw) throws IOException {
            int c;
            sw.write("\");out.print(\"${");
            while ((c = reader.read()) != -1) {
                if (c == 37) {
                    c = reader.read();
                    if (c == 62) break;
                    sw.write(37);
                }
                sw.write(c);
            }
            sw.write("}\");out.print(\"");
        }

        private void groovySection(Reader reader, StringWriter sw) throws IOException {
            int c;
            sw.write("\");");
            while ((c = reader.read()) != -1) {
                if (c == 37) {
                    c = reader.read();
                    if (c == 62) break;
                    sw.write(37);
                }
                sw.write(c);
            }
            sw.write(";out.print(\"");
        }
    }
}

