/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyRuntimeException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class GroovyClassLoader
extends SecureClassLoader {
    private Map cache = new HashMap();
    private CompilerConfiguration config;
    private String[] searchPaths;

    public GroovyClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public GroovyClassLoader(ClassLoader loader) {
        this(loader, new CompilerConfiguration());
    }

    public GroovyClassLoader(GroovyClassLoader parent) {
        this(parent, parent.config);
    }

    public GroovyClassLoader(ClassLoader loader, CompilerConfiguration config) {
        super(loader);
        this.config = config;
    }

    public Class defineClass(ClassNode classNode, String file) {
        return this.defineClass(classNode, file, "/groovy/defineClass");
    }

    public Class defineClass(ClassNode classNode, String file, String newCodeBase) {
        CodeSource codeSource = null;
        try {
            codeSource = new CodeSource(new URL("file", "", newCodeBase), null);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        CompilationUnit unit = new CompilationUnit(this.config, codeSource, this.getParent());
        try {
            ClassCollector collector = this.createCollector(unit);
            unit.addClassNode(classNode);
            unit.setClassgenCallback(collector);
            unit.compile(7);
            return collector.generatedClass;
        }
        catch (CompilationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    public Class parseClass(File file) throws CompilationFailedException, IOException {
        return this.parseClass(new GroovyCodeSource(file));
    }

    public Class parseClass(String text, String fileName) throws CompilationFailedException, IOException {
        return this.parseClass(new ByteArrayInputStream(text.getBytes()), fileName);
    }

    public Class parseClass(String text) throws CompilationFailedException, IOException {
        return this.parseClass(new ByteArrayInputStream(text.getBytes()), "script" + System.currentTimeMillis() + ".groovy");
    }

    public Class parseClass(InputStream in) throws CompilationFailedException, IOException {
        return this.parseClass(in, "script" + System.currentTimeMillis() + ".groovy");
    }

    public Class parseClass(final InputStream in, final String fileName) throws CompilationFailedException, IOException {
        GroovyCodeSource gcs = (GroovyCodeSource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new GroovyCodeSource(in, fileName, "/groovy/script");
            }
        });
        return this.parseClass(gcs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class parseClass(GroovyCodeSource codeSource) throws CompilationFailedException, IOException {
        Map map;
        String name = codeSource.getName();
        Class answer = null;
        Map map2 = this.cache;
        synchronized (map2) {
            answer = (Class)this.cache.get(name);
            if (answer != null) {
                return answer == PARSING.class ? null : answer;
            }
            this.cache.put(name, PARSING.class);
        }
        try {
            CompilationUnit unit = new CompilationUnit(this.config, codeSource.getCodeSource(), this);
            ClassCollector collector = this.createCollector(unit);
            unit.addSource(name, codeSource.getInputStream());
            unit.setClassgenCallback(collector);
            unit.compile(7);
            answer = collector.generatedClass;
            Object var7_7 = null;
            map = this.cache;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Map map3 = this.cache;
            synchronized (map3) {
                if (answer == null) {
                    this.cache.remove(name);
                } else {
                    this.cache.put(name, answer);
                }
            }
            throw throwable;
        }
        synchronized (map) {
            if (answer == null) {
                this.cache.remove(name);
            } else {
                this.cache.put(name, answer);
            }
        }
        return answer;
    }

    protected Class findClass(final String name) throws ClassNotFoundException {
        String className;
        int i;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (i = (className = name.replace('/', '.')).lastIndexOf(46)) != -1) {
            sm.checkPackageDefinition(className.substring(0, i));
        }
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return GroovyClassLoader.this.findGroovyClass(name);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
    }

    protected Class findGroovyClass(String name) throws ClassNotFoundException {
        String filename = name.replace('.', '/') + ".groovy";
        String[] paths = this.getClassPath();
        for (int i = 0; i < paths.length; ++i) {
            String pathName = paths[i];
            File path = new File(pathName);
            if (!path.exists()) continue;
            if (path.isDirectory()) {
                File file = new File(path, filename);
                if (!file.exists()) continue;
                try {
                    return this.parseClass(file);
                }
                catch (CompilationFailedException e) {
                    e.printStackTrace();
                    throw new ClassNotFoundException("Syntax error in groovy file: " + filename, e);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new ClassNotFoundException("Error reading groovy file: " + filename, e);
                }
            }
            try {
                JarFile jarFile = new JarFile(path);
                JarEntry entry = jarFile.getJarEntry(filename);
                if (entry == null) continue;
                byte[] bytes = this.extractBytes(jarFile, entry);
                Certificate[] certs = entry.getCertificates();
                try {
                    return this.parseClass(new GroovyCodeSource(new ByteArrayInputStream(bytes), filename, path, certs));
                }
                catch (CompilationFailedException e1) {
                    e1.printStackTrace();
                    throw new ClassNotFoundException("Syntax error in groovy file: " + filename, e1);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    throw new ClassNotFoundException("Error reading groovy file: " + filename, e1);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    private byte[] extractBytes(JarFile jarFile, JarEntry entry) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int b;
            BufferedInputStream bis = new BufferedInputStream(jarFile.getInputStream(entry));
            while ((b = bis.read()) != -1) {
                baos.write(b);
            }
        }
        catch (IOException ioe) {
            throw new GroovyRuntimeException("Could not read the jar bytes for " + entry.getName());
        }
        return baos.toByteArray();
    }

    private String[] getClassPath() {
        if (this.searchPaths == null) {
            ArrayList pathList = new ArrayList();
            String classpath = System.getProperty("java.class.path", ".");
            this.expandClassPath(pathList, null, classpath);
            this.searchPaths = new String[pathList.size()];
            this.searchPaths = pathList.toArray(this.searchPaths);
        }
        return this.searchPaths;
    }

    private void expandClassPath(List pathList, String base, String classpath) {
        if (classpath != null) {
            String[] paths = classpath.split("[\\ ,:;]");
            for (int i = 0; i < paths.length; ++i) {
                if (paths.length <= 0) continue;
                File path = null;
                path = "".equals(base) ? new File(paths[i]) : new File(base, paths[i]);
                if (!path.exists()) continue;
                if (!path.isDirectory()) {
                    try {
                        JarFile jar = new JarFile(path);
                        pathList.add(paths[i]);
                        Manifest manifest = jar.getManifest();
                        Attributes classPathAttributes = manifest.getMainAttributes();
                        String manifestClassPath = classPathAttributes.getValue("Class-Path");
                        if (manifestClassPath == null) continue;
                        this.expandClassPath(pathList, paths[i], manifestClassPath);
                    }
                    catch (IOException e) {}
                    continue;
                }
                pathList.add(paths[i]);
            }
        }
    }

    protected Class defineClass(String name, byte[] bytecode, ProtectionDomain domain) {
        return this.defineClass(name, bytecode, 0, bytecode.length, domain);
    }

    protected ClassCollector createCollector(CompilationUnit unit) {
        return new ClassCollector(this, unit);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        String className;
        int i;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (i = (className = name.replace('/', '.')).lastIndexOf(46)) != -1) {
            sm.checkPackageAccess(className.substring(0, i));
        }
        return super.loadClass(name, resolve);
    }

    public static class ClassCollector
    extends CompilationUnit.ClassgenCallback {
        private Class generatedClass;
        private GroovyClassLoader cl;
        private CompilationUnit unit;

        protected ClassCollector(GroovyClassLoader cl, CompilationUnit unit) {
            this.cl = cl;
            this.unit = unit;
        }

        protected Class onClassNode(ClassWriter classWriter, ClassNode classNode) {
            byte[] code = classWriter.toByteArray();
            Class theClass = this.cl.defineClass(classNode.getName(), code, 0, code.length, this.unit.getAST().getCodeSource());
            if (this.generatedClass == null) {
                this.generatedClass = theClass;
            }
            return theClass;
        }

        public void call(ClassVisitor classWriter, ClassNode classNode) {
            this.onClassNode((ClassWriter)classWriter, classNode);
        }
    }

    private class PARSING {
        private PARSING() {
        }
    }
}

