/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.seasar.framework.exception.SQLRuntimeException;

public final class DatabaseMetaDataUtil {
    private DatabaseMetaDataUtil() {
    }

    public static String[] getPrimaryKeys(DatabaseMetaData dbMetaData, String tableName) {
        Set set = DatabaseMetaDataUtil.getPrimaryKeySet(dbMetaData, tableName);
        return set.toArray(new String[set.size()]);
    }

    public static Set getPrimaryKeySet(DatabaseMetaData dbMetaData, String tableName) {
        if (!DatabaseMetaDataUtil.supportsMixedCaseIdentifiers(dbMetaData)) {
            tableName = tableName.toUpperCase();
        }
        HashSet<String> set = new HashSet<String>();
        try {
            ResultSet rs = dbMetaData.getPrimaryKeys(null, null, tableName);
            while (rs.next()) {
                set.add(rs.getString(4));
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
        return set;
    }

    public static String[] getColumns(DatabaseMetaData dbMetaData, String tableName) {
        Set set = DatabaseMetaDataUtil.getColumnSet(dbMetaData, tableName);
        return set.toArray(new String[set.size()]);
    }

    public static Set getColumnSet(DatabaseMetaData dbMetaData, String tableName) {
        if (!DatabaseMetaDataUtil.supportsMixedCaseIdentifiers(dbMetaData)) {
            tableName = tableName.toUpperCase();
        }
        HashSet<String> set = new HashSet<String>();
        try {
            ResultSet rs = dbMetaData.getColumns(null, null, tableName, null);
            while (rs.next()) {
                set.add(rs.getString(4));
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
        return set;
    }

    public static boolean supportsMixedCaseIdentifiers(DatabaseMetaData dbMetaData) {
        try {
            return dbMetaData.supportsMixedCaseIdentifiers();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }
}

