/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.deployer;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.assembler.AutoConstructorAssembler;
import org.seasar.framework.container.assembler.AutoPropertyAssembler;
import org.seasar.framework.container.assembler.ConstructorAssembler;
import org.seasar.framework.container.assembler.DefaultConstructorAssembler;
import org.seasar.framework.container.assembler.DefaultDestroyMethodAssembler;
import org.seasar.framework.container.assembler.DefaultInitMethodAssembler;
import org.seasar.framework.container.assembler.DefaultPropertyAssembler;
import org.seasar.framework.container.assembler.ExpressionConstructorAssembler;
import org.seasar.framework.container.assembler.ManualConstructorAssembler;
import org.seasar.framework.container.assembler.ManualPropertyAssembler;
import org.seasar.framework.container.assembler.MethodAssembler;
import org.seasar.framework.container.assembler.PropertyAssembler;
import org.seasar.framework.container.deployer.ComponentDeployer;
import org.seasar.framework.container.util.AutoBindingUtil;

public abstract class AbstractComponentDeployer
implements ComponentDeployer {
    private ComponentDef componentDef_;
    private ConstructorAssembler constructorAssembler_;
    private PropertyAssembler propertyAssembler_;
    private MethodAssembler initMethodAssembler_;
    private MethodAssembler destroyMethodAssembler_;

    public AbstractComponentDeployer(ComponentDef componentDef) {
        this.componentDef_ = componentDef;
        this.setupAssembler();
    }

    protected final ComponentDef getComponentDef() {
        return this.componentDef_;
    }

    protected final ConstructorAssembler getConstructorAssembler() {
        return this.constructorAssembler_;
    }

    protected final PropertyAssembler getPropertyAssembler() {
        return this.propertyAssembler_;
    }

    protected final MethodAssembler getInitMethodAssembler() {
        return this.initMethodAssembler_;
    }

    protected final MethodAssembler getDestroyMethodAssembler() {
        return this.destroyMethodAssembler_;
    }

    private void setupAssembler() {
        String autoBindingMode = this.componentDef_.getAutoBindingMode();
        if (AutoBindingUtil.isAuto(autoBindingMode)) {
            this.setupAssemblerForAuto();
        } else if (AutoBindingUtil.isConstructor(autoBindingMode)) {
            this.setupAssemblerForConstructor();
        } else if (AutoBindingUtil.isProperty(autoBindingMode)) {
            this.setupAssemblerForProperty();
        } else if (AutoBindingUtil.isNone(autoBindingMode)) {
            this.setupAssemblerForNone();
        } else {
            throw new IllegalArgumentException(autoBindingMode);
        }
        this.initMethodAssembler_ = new DefaultInitMethodAssembler(this.componentDef_);
        this.destroyMethodAssembler_ = new DefaultDestroyMethodAssembler(this.componentDef_);
    }

    private void setupAssemblerForAuto() {
        this.setupConstructorAssemblerForAuto();
        this.propertyAssembler_ = new AutoPropertyAssembler(this.componentDef_);
    }

    private void setupConstructorAssemblerForAuto() {
        this.constructorAssembler_ = this.componentDef_.getArgDefSize() > 0 ? new ManualConstructorAssembler(this.componentDef_) : (this.componentDef_.getExpression() != null ? new ExpressionConstructorAssembler(this.componentDef_) : new AutoConstructorAssembler(this.componentDef_));
    }

    private void setupAssemblerForConstructor() {
        this.setupConstructorAssemblerForAuto();
        this.propertyAssembler_ = new ManualPropertyAssembler(this.componentDef_);
    }

    private void setupAssemblerForProperty() {
        this.constructorAssembler_ = this.componentDef_.getExpression() != null ? new ExpressionConstructorAssembler(this.componentDef_) : new ManualConstructorAssembler(this.componentDef_);
        this.propertyAssembler_ = new AutoPropertyAssembler(this.componentDef_);
    }

    private void setupAssemblerForNone() {
        this.constructorAssembler_ = this.componentDef_.getArgDefSize() > 0 ? new ManualConstructorAssembler(this.componentDef_) : (this.componentDef_.getExpression() != null ? new ExpressionConstructorAssembler(this.componentDef_) : new DefaultConstructorAssembler(this.componentDef_));
        this.propertyAssembler_ = this.componentDef_.getPropertyDefSize() > 0 ? new ManualPropertyAssembler(this.componentDef_) : new DefaultPropertyAssembler(this.componentDef_);
    }

    public abstract Object deploy();

    public abstract void injectDependency(Object var1);

    public abstract void init();

    public abstract void destroy();
}

