/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import java.lang.reflect.Constructor;
import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.proxy.AopProxy;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.IllegalConstructorRuntimeException;
import org.seasar.framework.container.assembler.AbstractAssembler;
import org.seasar.framework.container.assembler.ConstructorAssembler;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ConstructorUtil;

public abstract class AbstractConstructorAssembler
extends AbstractAssembler
implements ConstructorAssembler {
    public AbstractConstructorAssembler(ComponentDef componentDef) {
        super(componentDef);
    }

    protected final AopProxy createAopProxy() {
        return new AopProxy(this.getComponentDef().getComponentClass(), this.getAspects());
    }

    protected Object assembleDefault() {
        if (this.getComponentDef().getAspectDefSize() > 0) {
            AopProxy aopProxy = this.createAopProxy();
            return aopProxy.create();
        }
        Class clazz = this.getComponentDef().getComponentClass();
        Constructor constructor = ClassUtil.getConstructor(clazz, null);
        return ConstructorUtil.newInstance(constructor, null);
    }

    private Aspect[] getAspects() {
        int size = this.getComponentDef().getAspectDefSize();
        Aspect[] aspects = new Aspect[size];
        int i = 0;
        while (i < size) {
            AspectDef aspectDef = this.getComponentDef().getAspectDef(i);
            aspects[i] = aspectDef.getAspect();
            ++i;
        }
        return aspects;
    }

    public abstract Object assemble() throws IllegalConstructorRuntimeException;
}

