package org.seasar.framework.util;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

import org.seasar.framework.exception.SQLRuntimeException;

/**
 * @author higa
 *
 */
public final class DatabaseMetaDataUtil {

	private DatabaseMetaDataUtil() {
	}

	public static String[] getPrimaryKeys(
		DatabaseMetaData dbMetaData,
		String tableName) {

		Set set = getPrimaryKeySet(dbMetaData, tableName);
		return (String[]) set.toArray(new String[set.size()]);
	}

	public static Set getPrimaryKeySet(
		DatabaseMetaData dbMetaData,
		String tableName) {

		if (!supportsMixedCaseIdentifiers(dbMetaData)) {
			tableName = tableName.toUpperCase();
		}
		Set set = new HashSet();
		try {
			ResultSet rs = dbMetaData.getPrimaryKeys(null, null, tableName);
			while (rs.next()) {
				set.add(rs.getString(4));
			}
			rs.close();
		} catch (SQLException ex) {
			throw new SQLRuntimeException(ex);
		}
		return set;
	}

	public static String[] getColumns(
		DatabaseMetaData dbMetaData,
		String tableName) {

		Set set = getColumnSet(dbMetaData, tableName);
		return (String[]) set.toArray(new String[set.size()]);
	}

	public static Set getColumnSet(
		DatabaseMetaData dbMetaData,
		String tableName) {

		if (!supportsMixedCaseIdentifiers(dbMetaData)) {
			tableName = tableName.toUpperCase();
		}
		Set set = new HashSet();
		try {
			ResultSet rs = dbMetaData.getColumns(null, null, tableName, null);
			while (rs.next()) {
				set.add(rs.getString(4));
			}
			rs.close();
		} catch (SQLException ex) {
			throw new SQLRuntimeException(ex);
		}
		return set;
	}

	public static boolean supportsMixedCaseIdentifiers(DatabaseMetaData dbMetaData) {

		try {
			return dbMetaData.supportsMixedCaseIdentifiers();
		} catch (SQLException ex) {
			throw new SQLRuntimeException(ex);
		}
	}
}