package org.seasar.framework.sel.parser;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.StringUtil;

/**
 * @author higa
 *
 */
public class StaticFieldParser {

	private String s_;
	private Object fieldValue_;
	private String remainingString_;
	
	public StaticFieldParser(String s) {
		s_ = s;
	}
	
	public Object getFieldValue() {
		return fieldValue_;
	}
	
	public String getRemainingString() {
		return remainingString_;
	}
	
	public boolean parse() {
		String[] names = StringUtil.split(s_, ".");
		StringBuffer nameBuf = new StringBuffer(100);
		for (int i = 0; i < names.length - 1; ++i) {
			nameBuf.append(names[i]);
			if (Character.isUpperCase(names[i].charAt(0))) {
				Class targetClass = ClassUtil.forName(nameBuf.toString());
				if (Character.isUpperCase(names[i + 1].charAt(0))) {
					try {
						Field field = targetClass.getField(names[i + 1]);
						if (!Modifier.isStatic(field.getModifiers())) {
							continue;
						}
						fieldValue_ = FieldUtil.get(field, targetClass);
						setupRemainingString(names, i);
						return true;
					} catch (NoSuchFieldException ignore) {
						continue;
					}
				} else if (names[i + 1].equals("class")) {
					fieldValue_ = targetClass;
					setupRemainingString(names, i);
					return true;
				}
			}
			nameBuf.append('.');
		}
		return false;
	}
	
	private void setupRemainingString(String[] names, int index) {
		if (index != names.length - 2) {
			StringBuffer remainingBuf = new StringBuffer();
			for (int i = index + 2; i < names.length; ++i) {
				remainingBuf.append(names[i]);
				remainingBuf.append('.');
			}
			remainingBuf.setLength(remainingBuf.length() - 1);
			remainingString_ = remainingBuf.toString();
		}
	}
}
