package org.seasar.framework.sel.context;

import java.util.HashMap;
import java.util.Map;

import org.seasar.framework.sel.SelContext;
import org.seasar.framework.sel.VariableNotFoundRuntimeException;
import org.seasar.framework.sel.util.PropertyUtil;

public class SelContextImpl implements SelContext {

	private Map variables_ = new HashMap();

	/**
	 * @see org.seasar.framework.sel.SelContext#getVariable(java.lang.String)
	 */
	public Object getVariable(String name) {
		Object var = variables_.get(name);
		if (var == null) {
			throw new VariableNotFoundRuntimeException(name);
		}
		return var;
	}

	/**
	 * @see org.seasar.framework.sel.SelContext#setVariable(java.lang.String, java.lang.Object)
	 */
	public void setVariable(String name, Object value) {
		variables_.put(name, value);
	}

	/**
	 * @see org.seasar.framework.sel.SelContext#getProperty(java.lang.Object, java.lang.String)
	 */
	public Object getProperty(Object variable, String propertyName) {
		return PropertyUtil.getProperty(variable, propertyName);
	}

}
