package test.org.seasar.framework.container.impl;

import junit.framework.TestCase;

import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.impl.ArgDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;

/**
 * @author higa
 *
 */
public class ArgDefImplTest extends TestCase {

	/**
	 * Constructor for InvocationImplTest.
	 * @param arg0
	 */
	public ArgDefImplTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(ArgDefImplTest.class);
	}

	public void testSetExpression() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(A.class);
		ArgDef ad = new ArgDefImpl();
		ad.setExpression("aaa:hoge");
		cd.addArgDef(ad);
		container.register(cd);
		ComponentDefImpl cd2 = new ComponentDefImpl(B.class, "aaa:hoge");
		container.register(cd2);
		container.register(C.class);
		A a = (A) container.getComponent(A.class);
		assertEquals("1", "B", a.getHogeName());
	}
	
	public void testSetChildComponentDef() throws Exception {
		S2Container container = new S2ContainerImpl();
		ComponentDefImpl cd = new ComponentDefImpl(A.class);
		ArgDef ad = new ArgDefImpl();
		ComponentDefImpl cd2 = new ComponentDefImpl(B.class);
		ad.setChildComponentDef(cd2);
		cd.addArgDef(ad);
		container.register(cd);
		container.register(C.class);
		A a = (A) container.getComponent(A.class);
		assertEquals("1", "B", a.getHogeName());
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public static class A {

		private Hoge hoge_;

		public A(Hoge hoge) {
			hoge_ = hoge;
		}

		public String getHogeName() {
			return hoge_.getName();
		}
	}

	public static class A2 {

		private Hoge hoge_;

		public void setHoge(Hoge hoge) {
			hoge_ = hoge;
		}

		public String getHogeName() {
			return hoge_.getName();
		}
	}

	public interface Hoge {

		public String getName();
	}

	public static class B implements Hoge {

		public String getName() {
			return "B";
		}
	}

	public static class C implements Hoge {

		private A2 a2_;

		public void setA2(A2 a2) {
			a2_ = a2;
		}

		public String getName() {
			return "C";
		}

		public String getHogeName() {
			return a2_.getHogeName();
		}
	}
}