package org.seasar.framework.container.servlet;

import java.io.IOException;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.util.StringUtil;

public class S2ContainerServlet extends HttpServlet {

	public static final String CONFIG_PATH_KEY = "configPath";
	public static final String DEFAULT_CONFIG_PATH = "app-config.xml";
	private static S2Container container_;

	public void init() {
		String configPath =
			getServletConfig().getInitParameter(CONFIG_PATH_KEY);
		if (StringUtil.isEmpty(configPath)) {
			configPath = DEFAULT_CONFIG_PATH;
		}
		container_ = S2ContainerFactory.create(configPath);
		container_.init();
		getServletConfig().getServletContext().setAttribute(
			S2Container.class.getName(),
			container_);
	}

	public void destroy() {
		container_.destroy();
		container_ = null;
	}

	public static S2Container getContainer() {
		return container_;
	}

	public static S2Container getContainer(ServletContext ctx) {
		return (S2Container) ctx.getAttribute(S2Container.class.getName());
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response)
		throws IOException, ServletException {

		response.getWriter().write("S2ContainerServlet is running.");
	}
}