package org.seasar.extension.jdbc.impl;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.RowHandler;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.ClassUtil;

public class BeanRowHandler implements RowHandler {

	private Class beanClass_;

	public BeanRowHandler(Class beanClass) {
		beanClass_ = beanClass;
	}

	public Object createRowValue(ResultSet rs, PropertyType[] propertyTypes)
		throws SQLException {

		Object row = ClassUtil.newInstance(beanClass_);
		BeanDesc beanDesc = BeanDescFactory.getBeanDesc(beanClass_);
		for (int i = 0; i < propertyTypes.length; ++i) {
			String propertyName = propertyTypes[i].getPropertyName();
			ValueType valueType = propertyTypes[i].getValueType();
			if (beanDesc.hasPropertyDesc(propertyName)) {
				Object value = valueType.getValue(rs, i + 1);
				PropertyDesc pd = beanDesc.getPropertyDesc(propertyName);
				pd.setValue(row, value);
			}
		}
		return row;
	}
}