package org.seasar.framework.util;

import java.sql.Connection;
import java.sql.SQLException;

import org.seasar.framework.exception.SQLRuntimeException;

/**
 * @author higa
 *
 */
public final class ConnectionUtil {

	private ConnectionUtil() {
	}

	public static void close(Connection connection) {
		if (connection == null) {
			return;
		}
		try {
			connection.close();
		} catch (SQLException ex) {
			throw new SQLRuntimeException(ex);
		}
	}
}
