package org.seasar.framework.util;

import java.sql.Timestamp;

public final class TimestampConversionUtil {

	private TimestampConversionUtil() {
	}

	public static Timestamp toTimestamp(Object o) {
		return toTimestamp(o, null);
	}
	
	public static Timestamp toTimestamp(Object o, String pattern) {
		if (o instanceof Timestamp) {
			return (Timestamp) o;
		} else {
			return new Timestamp(DateConversionUtil.toDate(o, pattern).getTime());
		}
	}
}
