package org.seasar.framework.container.assembler;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.DestroyMethodDef;
import org.seasar.framework.container.IllegalMethodRuntimeException;

/**
 * @author higa
 *
 */
public class DefaultDestroyMethodAssembler extends AbstractMethodAssembler {

	/**
	 * @param componentDef
	 */
	public DefaultDestroyMethodAssembler(ComponentDef componentDef) {
		super(componentDef);
	}

	public void assemble(Object component)
		throws IllegalMethodRuntimeException {

		BeanDesc beanDesc = getBeanDesc();
		int size = getComponentDef().getDestroyMethodDefSize();
		for (int i = 0; i < size; ++i) {
			DestroyMethodDef methodDef = getComponentDef().getDestroyMethodDef(i);
			Object[] args = null;
			try {
				args = methodDef.getArgs();
			} catch (ComponentNotFoundRuntimeException cause) {
				throw new IllegalMethodRuntimeException(
					getComponentDef().getComponentClass(),
					methodDef.getMethodName(),
					cause);
			}
			invoke(beanDesc, component, methodDef.getMethodName(), args);
		}
	}

}
