package test.org.seasar.framework.sel.parser;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.sel.parser.StaticFieldParser;

public class StaticFieldParserTest extends TestCase {

	public static final String HOGE = "hoge";

	public StaticFieldParserTest(String name) {
		super(name);
	}

	public void testStaticField() throws Exception {
		StaticFieldParser parser =
			new StaticFieldParser("java.lang.Integer.MIN_VALUE");
		assertEquals("1", true, parser.parse());
		assertEquals(
			"2",
			new Integer(Integer.MIN_VALUE),
			parser.getFieldValue());
		assertEquals("3", null, parser.getRemainingString());
	}

	public void testStaticField2() throws Exception {
		StaticFieldParser parser =
			new StaticFieldParser("test.org.seasar.framework.sel.parser.SelParserTest.HOGE.toUpperCase()");
		assertEquals("1", true, parser.parse());
		assertEquals("2", HOGE, parser.getFieldValue());
		assertEquals("3", "toUpperCase()", parser.getRemainingString());
	}
	
	public void testStaticField3() throws Exception {
		StaticFieldParser parser =
			new StaticFieldParser("aaa.bbb.ccc");
		assertEquals("1", false, parser.parse());
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(StaticFieldParserTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { StaticFieldParserTest.class.getName()});
	}
}