package org.seasar.framework.sel.exps;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;
import org.seasar.framework.sel.util.SelContextUtil;

public class MethodExp implements Expression {

	private Expression targetExp_;
	private String methodName_;
	private Expression[] exps_;

	public MethodExp(
		Expression targetExp,
		String methodName,
		Expression[] exps) {

		targetExp_ = targetExp;
		methodName_ = methodName;
		exps_ = exps;
	}

	public Object evaluateValue(SelContext context) {
		Object target = targetExp_.evaluateValue(context);
		Object[] args = SelContextUtil.evaluateValues(context, exps_);
		BeanDesc beanDesc = BeanDescFactory.getBeanDesc(target.getClass());
		return beanDesc.invoke(target, methodName_, args);
	}
}
