package org.seasar.framework.container.assembler;

import org.seasar.framework.container.ClassUnmatchRuntimeException;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.IllegalConstructorRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.parser.SelParser;

/**
 * @author higa
 *
 */
public final class ExpressionConstructorAssembler
	extends AbstractConstructorAssembler {

	/**
	 * @param componentDef
	 */
	public ExpressionConstructorAssembler(ComponentDef componentDef) {
		super(componentDef);
	}

	public Object assemble()
		throws IllegalConstructorRuntimeException {

		ComponentDef cd = getComponentDef();
		S2Container container = cd.getContainer();
		String expression = cd.getExpression();
		Class componentClass = cd.getComponentClass();
		Object component = null;
		if (container.hasComponentDef(expression)) {
			component = container.getComponentDef(expression).getComponent();
		} else {
			Expression exp = new SelParser(expression).parseExpression();
			component = exp.evaluateValue(container.getSelContext());
		}
		if (componentClass != null) {
			if (!componentClass.isInstance(component)) {
				throw new ClassUnmatchRuntimeException(componentClass,
					component.getClass());
			}
		}
		return component;

	}
}
