package test.org.seasar.framework.sel.exps;

import java.util.HashMap;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.sel.SelContext;
import org.seasar.framework.sel.context.SelContextImpl;
import org.seasar.framework.sel.exps.GetPropertyExp;
import org.seasar.framework.sel.exps.GetVariableExp;

public class GetPropertyExpTest extends TestCase {

	public GetPropertyExpTest(String name) {
		super(name);
	}

	public void testEvaluateValue() throws Exception {
		SelContext ctx = new SelContextImpl();
		Map aaa = new HashMap();
		ctx.setVariable("aaa", aaa);
		aaa.put("bbb", "hoge");
		GetPropertyExp exp = new GetPropertyExp(new GetVariableExp("aaa"),"bbb");
		assertEquals("1", "hoge", exp.evaluateValue(ctx));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(GetPropertyExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { GetPropertyExpTest.class.getName()});
	}
}