package test.org.seasar.framework.sel.boolexps;

import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.boolexps.GreaterEqualExp;
import org.seasar.framework.sel.exps.ObjectExp;
import org.seasar.framework.sel.exps.NullExp;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class GreaterEqualExpTest extends TestCase {

	public GreaterEqualExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		String s = "1234567890";
		String s2 = "1234567891";
		Integer i = new Integer(s);
		Integer i2 = new Integer(s2);
		Expression iExp = new ObjectExp(i);
		Expression i2Exp = new ObjectExp(i2);
		GreaterEqualExp geExp = new GreaterEqualExp(iExp, iExp);
		assertEquals("1", true, geExp.evaluate(null));

		GreaterEqualExp ge2Exp = new GreaterEqualExp(i2Exp, iExp);
		assertEquals("2", true, ge2Exp.evaluate(null));

		GreaterEqualExp ge3Exp = new GreaterEqualExp(iExp, i2Exp);
		assertEquals("3", false, ge3Exp.evaluate(null));

		GreaterEqualExp ge4Exp = new GreaterEqualExp(iExp, NullExp.NULL);
		assertEquals("4", false, ge4Exp.evaluate(null));

		GreaterEqualExp ge5Exp = new GreaterEqualExp(NullExp.NULL, iExp);
		assertEquals("5", false, ge5Exp.evaluate(null));

		GreaterEqualExp ge6Exp =
			new GreaterEqualExp(NullExp.NULL, NullExp.NULL);
		assertEquals("6", false, ge6Exp.evaluate(null));

	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(GreaterEqualExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { GreaterEqualExpTest.class.getName()});
	}
}