package test.org.seasar.framework.aop.proxy;

import java.util.Date;

import junit.framework.TestCase;

import org.seasar.framework.aop.AroundAdvice;
import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.Joinpoint;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.advices.TraceAdvice;
import org.seasar.framework.aop.impl.AspectImpl;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.aop.proxy.AopProxy;

/**
 * @author higa
 *
 */
public class AopProxyTest extends TestCase {

	/**
	 * Constructor for InvocationImplTest.
	 * @param arg0
	 */
	public AopProxyTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(AopProxyTest.class);
	}

	public void testIntercept() throws Exception {
		TestAdvice advice = new TestAdvice();
		Pointcut pointcut =
			new PointcutImpl(new String[]{ "getTime" });
		Aspect aspect = new AspectImpl(advice, pointcut);
		AopProxy aopProxy =
			new AopProxy(Date.class, new Aspect[] {aspect});
		Date proxy = (Date) aopProxy.create();
		System.out.println(proxy.getTime());
		assertEquals("2", true, advice.invoked_);
	}
	
	public void testInterface() throws Exception {
		AroundAdvice advice = new HelloAdvice();
		Pointcut pointcut =
			new PointcutImpl(new String[]{ "greeting" });
		Aspect aspect = new AspectImpl(advice, pointcut);
		AopProxy aopProxy =
			new AopProxy(Hello.class, new Aspect[] {aspect});
		Hello proxy = (Hello) aopProxy.create();
		assertEquals("1", "Hello", proxy.greeting());
	}
	
	public void testCreateForArgs() throws Exception {
		Aspect aspect = new AspectImpl(new TraceAdvice());
		AopProxy aopProxy =
			new AopProxy(HelloImpl.class, new Aspect[] {aspect});
		Hello proxy = (Hello) aopProxy.create(new Class[]{String.class},
			new Object[]{"Hello"});
		assertEquals("1", "Hello", proxy.greeting());
	}
	
	public void testEquals() throws Exception {
		AroundAdvice advice = new HelloAdvice();
		Pointcut pointcut =
			new PointcutImpl(new String[]{ "greeting" });
		Aspect aspect = new AspectImpl(advice, pointcut);
		AopProxy aopProxy =
			new AopProxy(Hello.class, new Aspect[] {aspect});
		Hello proxy = (Hello) aopProxy.create();
		assertEquals("1", true, proxy.equals(proxy));
		assertEquals("2", false, proxy.equals(null));
		assertEquals("3", false, proxy.equals("hoge"));
	}
	
	public void testPerformance() throws Exception {
		Date target = new Date();
		TestAdvice advice = new TestAdvice();
		Pointcut pointcut =
			new PointcutImpl(new String[]{ "getTime" });
		Aspect aspect = new AspectImpl(advice, pointcut);
		AopProxy aopProxy =
			new AopProxy(Date.class, new Aspect[] {aspect});
		Date proxy = (Date) aopProxy.create();
		final int num = 2000000;
		long start = System.currentTimeMillis();
		for (int i = 0; i < num; ++i) {
			//target.hashCode();
			target.getTime();
		}
		System.out.println("target:" + (System.currentTimeMillis() - start));
		
		start = System.currentTimeMillis();
		for (int i = 0; i < num; ++i) {
			//proxy.hashCode();
			proxy.getTime();
		}
		System.out.println("proxy:" + (System.currentTimeMillis() - start));
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public class TestAdvice implements AroundAdvice {

		private boolean invoked_ = false;

		public Object invoke(Joinpoint joinpoint) throws Throwable {
			invoked_ = true;
			return joinpoint.proceed();
		}

	}
	
	public interface Hello {
		public String greeting();
	}
	
	public static class HelloImpl implements Hello {
		
		private String str_;
		
		public HelloImpl(String str) {
			str_ = str;
		}
		
		public String greeting() {
			return str_;
		}
	}
	
	public class HelloAdvice implements AroundAdvice {
		public Object invoke(Joinpoint joinpoint) throws Throwable {
			return "Hello";
		}
	}
}