package test.org.seasar.extension.dataset.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataWriter;
import org.seasar.extension.dataset.reader.XlsReader;
import org.seasar.extension.dataset.writer.XlsWriter;
import org.seasar.framework.util.ResourceUtil;

public class XlsWriterTest extends TestCase {

	private static final String PATH =
		"test/org/seasar/extension/dataset/reader/XlsReaderTest.xls";
	private static final String PATH2 =
		"test/org/seasar/extension/dataset/writer/XlsWriterTest.xls";

	private DataSet dataSet_;
	private OutputStream out_;
	private DataWriter writer_;

	public XlsWriterTest(String name) {
		super(name);
	}

	public void testWrite() throws Exception {
		writer_.write(dataSet_);
	}

	protected void setUp() throws Exception {
		dataSet_ = new XlsReader(ResourceUtil.getResourceAsStream(PATH)).read();
		out_ =
			new FileOutputStream(
				new File(ResourceUtil.getBuildDir(getClass()), PATH2));
		writer_ = new XlsWriter(out_);
	}

	protected void tearDown() throws Exception {
		out_.close();
	}

	public static Test suite() {
		return new TestSuite(XlsWriterTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { XlsWriterTest.class.getName()});
	}
}