package org.seasar.framework.util;

import java.text.SimpleDateFormat;

public final class LongConversionUtil {

	private LongConversionUtil() {
	}

	public static Long toLong(Object o) {
		return toLong(o, null);
	}
	
	public static Long toLong(Object o, String pattern) {
		if (o == null) {
			return null;
		} else if (o instanceof Long) {
			return (Long) o;
		} else if (o instanceof Number) {
			return new Long(((Number) o).longValue());
		} else if (o instanceof String) {
			return new Long((String) o);
		} else if (o instanceof java.util.Date) {
			if (pattern != null) {
				return new Long(new SimpleDateFormat(pattern).format(o));
			} else {
				return new Long(((java.util.Date) o).getTime());
			}
		} else {
			return new Long(o.toString());
		}
	}
}
