package org.seasar.framework.sel.parser;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.StringUtil;

/**
 * @author higa
 *
 */
public class StaticFieldParser {

	private String s_;
	private Object fieldValue_;
	private String remainingString_;
	
	public StaticFieldParser(String s) {
		s_ = s;
	}
	
	public Object getFieldValue() {
		return fieldValue_;
	}
	
	public String getRemainingString() {
		return remainingString_;
	}
	
	public boolean parse() {
		String[] names = StringUtil.split(s_, ".");
		StringBuffer nameBuf = new StringBuffer(100);
		for (int i = 0; i < names.length - 1; ++i) {
			nameBuf.append(names[i]);
			if (Character.isUpperCase(names[i].charAt(0))
				&& Character.isUpperCase(names[i + 1].charAt(0))) {
				try {
					Class targetClass = ClassUtil.forName(nameBuf.toString());
					Field field = targetClass.getField(names[i + 1]);
					if (!Modifier.isStatic(field.getModifiers())) {
						continue;
					}
					fieldValue_ = FieldUtil.get(field, targetClass);
					if (i != names.length - 2) {
						StringBuffer remainingBuf = new StringBuffer();
						for (int j = i + 2; j < names.length; ++j) {
							remainingBuf.append(names[j]);
							remainingBuf.append('.');
						}
						remainingBuf.setLength(remainingBuf.length() - 1);
						remainingString_ = remainingBuf.toString();
					}
					return true;
				} catch (NoSuchFieldException ignore) {
					continue;
				}
			}
			nameBuf.append('.');
		}
		return false;
	}
}
