package org.seasar.framework.sel.exps;

import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;

public final class GetVariableExp implements Expression {

	private String name_;
	
	public GetVariableExp(String name) {
		name_ = name;
		if (name_.startsWith("\"")) {
			name_ = name_.substring(1);
		}
		if (name_.endsWith("\"")) {
			name_ = name_.substring(0, name_.length() - 1);
		}
	}

	public Object evaluateValue(SelContext context) {
		return context.getVariable(name_);
	}
}
