package org.seasar.framework.sel.boolexps;

import java.util.List;

import org.seasar.framework.sel.BoolExpression;
import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;

public final class InExp implements BoolExpression {

	private Expression targetExp_;
	private Expression[] inExps_;

	public InExp(Expression targetExp, Expression[] inExps) {
		targetExp_ = targetExp;
		inExps_ = inExps;
	}

	public boolean evaluate(SelContext context) {
		Comparable target = (Comparable) targetExp_.evaluateValue(context);
		if (target == null) {
			return false;
		}
		for (int i = 0; i < inExps_.length; i++) {
			Expression inArgExp = inExps_[i];
			Object inArg = inArgExp.evaluateValue(context);
			if (inArg == null) {
				continue;
			}
			if (inArg instanceof List) {
				List list = (List) inArg;
				for (int j = 0; j < list.size(); ++j) {
					Object o = list.get(j);
					if (o != null && target.compareTo(o) == 0) {
						return true;
					}
				}
			} else if (inArg.getClass().isArray()) {
				Object[] array = (Object[]) inArg;
				for (int j = 0; j < array.length; ++j) {
					if (array[j] != null && target.compareTo(array[j]) == 0) {
						return true;
					}
				}
			} else if (target.compareTo(inArg) == 0) {
				return true;
			}
		}
		return false;
	}
}
