package org.seasar.framework.container;

import org.seasar.framework.sel.SelContext;

/**
 * @author higa
 *
 * IoC̃Rei@\񋟂܂B
 */
public interface S2Container {

	public String NAME = "s2/container";

	public Object getComponent(Object componentKey)
		throws
			ComponentNotFoundRuntimeException,
			TooManyRegistrationRuntimeException,
			CyclicReferenceRuntimeException;

	public void injectDependency(Object outerComponent)
		throws ClassUnmatchRuntimeException;

	public void injectDependency(Object outerComponent, Class componentClass)
		throws ClassUnmatchRuntimeException;

	public void injectDependency(Object outerComponent, String componentName)
		throws ClassUnmatchRuntimeException;

	public void register(Object component);
	
	public void register(Object component, String componentName);

	public void register(Class componentClass);

	public void register(Class componentClass, String componentName);

	public void register(ComponentDef componentDef);

	public int getComponentDefSize();

	public ComponentDef getComponentDef(int index);

	public ComponentDef getComponentDef(Object componentKey)
		throws ComponentNotFoundRuntimeException;

	public boolean hasComponentDef(Object componentKey);

	public void include(S2Container child);

	public SelContext getSelContext();

	public void init();

	public void destroy();
	
	public String getNamespace();
	
	public void setNamespace(String namespace);
	
	public S2Container getRootContainer();
	
	public void setRootContainer(S2Container rootContainer);

}
