package org.seasar.extension.tx;

import javax.transaction.TransactionManager;

import org.seasar.framework.aop.Joinpoint;

/**
 * @author higa
 *
 */
public class RequiredAdvice extends AbstractTxAdvice {
	
	public RequiredAdvice(TransactionManager transactionManager) {
		super(transactionManager);
	}

	/**
	 * @see org.seasar.framework.aop.AroundAdvice#invoke(org.seasar.framework.aop.Joinpoint)
	 */
	public Object invoke(Joinpoint joinpoint) throws Throwable {
		boolean began = false;
		if (!hasTransaction()) {
			begin();
			began = true;
		} 
		Object ret = null;
		try {
			ret = joinpoint.proceed();
			if (began) {
				commit();
			}
			return ret;
		} catch (Throwable t) {
			if (began) {
				rollback();
			}
			throw t;
		}
	}
}