package org.seasar.extension.tx;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Status;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

import org.seasar.framework.aop.AroundAdvice;

/**
 * @author higa
 *
 */
public abstract class AbstractTxAdvice implements AroundAdvice {

	private TransactionManager transactionManager_;

	public AbstractTxAdvice(TransactionManager transactionManager) {
		transactionManager_ = transactionManager;
	}

	public final TransactionManager getTransactionManager() {
		return transactionManager_;
	}

	public final boolean hasTransaction() throws SystemException {
		return transactionManager_.getStatus() != Status.STATUS_NO_TRANSACTION;
	}
	
	public final Transaction getTransaction() throws SystemException {
		return transactionManager_.getTransaction();
	}

	public final void begin() throws NotSupportedException, SystemException {
		transactionManager_.begin();
	}

	public final void commit()
		throws
			SecurityException,
			IllegalStateException,
			RollbackException,
			HeuristicMixedException,
			HeuristicRollbackException,
			SystemException {

		transactionManager_.commit();
	}

	public final void rollback()
		throws IllegalStateException, SecurityException, SystemException {
		
		if (hasTransaction()) {
			transactionManager_.rollback();
		}
	}

	public final Transaction suspend() throws SystemException {
		return transactionManager_.suspend();
	}

	public final void resume(Transaction transaction)
		throws InvalidTransactionException, IllegalStateException, SystemException {
		transactionManager_.resume(transaction);
	}
}
