package org.seasar.extension.dataset.impl;

import org.seasar.extension.dataset.ColumnNotFoundRuntimeException;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataTable;
import org.seasar.framework.util.ArrayMap;

/**
 * @author higa
 *
 */
public class DataRowImpl implements DataRow {

	private DataTable table_;
	private ArrayMap values_ = new ArrayMap();

	public DataRowImpl(DataTable table) {
		table_ = table;
		initValues();
	}

	/**
	 * @see org.seasar.extension.dataset.DataRow#getValue(int)
	 */
	public Object getValue(int index) {
		return values_.get(index);
	}

	private void assertContainsColumnName(String columnName)
		throws ColumnNotFoundRuntimeException {

		if (!values_.containsKey(columnName)) {
			throw new ColumnNotFoundRuntimeException(columnName);
		}
	}

	/**
	 * @see org.seasar.extension.dataset.DataRow#getValue(java.lang.String)
	 */
	public Object getValue(String columnName)
		throws ColumnNotFoundRuntimeException {

		assertContainsColumnName(columnName);
		return values_.get(columnName);
	}

	/**
	 * @see org.seasar.extension.dataset.DataRow#setValue(java.lang.String, java.lang.Object)
	 */
	public void setValue(String columnName, Object value)
		throws ColumnNotFoundRuntimeException {

		assertContainsColumnName(columnName);
		values_.put(columnName, value);
	}

	/**
	 * @see org.seasar.extension.dataset.DataRow#setValue(int, java.lang.Object)
	 */
	public void setValue(int index, Object value) {
		values_.set(index, value);
	}

	private void initValues() {
		for (int i = 0; i < table_.getColumnSize(); ++i) {
			values_.put(table_.getColumn(i).getColumnName(), null);
		}
	}
}
