package test.org.seasar.framework.sel.boolexps;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.framework.sel.boolexps.LessThanExp;
import org.seasar.framework.sel.exps.NullExp;
import org.seasar.framework.sel.exps.ObjectExp;

public class LessThanExpTest extends TestCase {

	public LessThanExpTest(String name) {
		super(name);
	}

	public void testEvaluate() throws Exception {
		String s = "1234567890";
		String s2 = "1234567891";
		Integer i = new Integer(s);
		Integer i2 = new Integer(s2);
		ObjectExp iExp = new ObjectExp(i);
		ObjectExp i2Exp = new ObjectExp(i2);
		LessThanExp ltExp = new LessThanExp(iExp, iExp);
		assertEquals("1", false, ltExp.evaluate(null));

		LessThanExp lt2Exp = new LessThanExp(i2Exp, iExp);
		assertEquals("2", false, lt2Exp.evaluate(null));

		LessThanExp lt3Exp = new LessThanExp(iExp, i2Exp);
		assertEquals("3", true, lt3Exp.evaluate(null));

		LessThanExp lt4Exp = new LessThanExp(iExp, NullExp.NULL);
		assertEquals("4", false, lt4Exp.evaluate(null));

		LessThanExp lt5Exp = new LessThanExp(NullExp.NULL, iExp);
		assertEquals("5", false, lt5Exp.evaluate(null));

		LessThanExp lt6Exp = new LessThanExp(NullExp.NULL, NullExp.NULL);
		assertEquals("6", false, lt6Exp.evaluate(null));
	}

	protected void setUp() throws Exception {
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(LessThanExpTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.main(
			new String[] { LessThanExpTest.class.getName()});
	}
}