package org.seasar.framework.container.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.sel.SelContext;

/**
 * @author higa
 *
 */
public class S2ContainerImpl implements S2Container {

	private Map componentDefMap_ = new HashMap();
	private List componentDefList_ = new ArrayList();
	private SelContext selContext_ = new S2ContainerSelContext(this);

	public S2ContainerImpl() {
		register0(new SimpleComponentDef(this, NAME));
		componentDefMap_.put("out", new SimpleComponentDef(System.out, "out"));
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getComponent(java.lang.Class)
	 */
	public Object getComponent(Class componentClass) {
		return getComponentDef0(componentClass).getComponent();
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getComponent(java.lang.String)
	 */
	public Object getComponent(String componentName) {
		return getComponentDef0(componentName).getComponent();
	}
	
	/**
	 * @see org.seasar.framework.container.S2Container#injectDependency(java.lang.Object)
	 */
	public void injectDependency(Object outerComponent) {
		injectDependency(outerComponent, outerComponent.getClass());
	}
	
	/**
	 * @see org.seasar.framework.container.S2Container#injectDependency(java.lang.Object, java.lang.Class)
	 */
	public void injectDependency(Object outerComponent, Class componentClass) {
		getComponentDef(componentClass).injectDependency(outerComponent);
	}
	
	/**
	 * @see org.seasar.framework.container.S2Container#injectDependency(java.lang.Object, java.lang.String)
	 */
	public void injectDependency(Object outerComponent, String componentName) {
		getComponentDef(componentName).injectDependency(outerComponent);
	}

	/**
	 * @see org.seasar.framework.container.S2Container#register(java.lang.Class)
	 */
	public void register(Class componentClass) {
		register(new ComponentDefImpl(componentClass));
	}

	/**
	 * @see org.seasar.framework.container.S2Container#register(java.lang.Class, java.lang.String)
	 */
	public void register(Class componentClass, String componentName) {
		register(new ComponentDefImpl(componentClass, componentName));
	}

	/**
	 * @see org.seasar.framework.container.S2Container#register(org.seasar.framework.container.ComponentDef)
	 */
	public void register(ComponentDef componentDef) {
		register0(componentDef);
		componentDefList_.add(componentDef);
	}
	
	private void register0(ComponentDef componentDef) {
		componentDef.setContainer(this);
		Class[] classes =
			getAssignableClasses(componentDef.getComponentClass());
		for (int i = 0; i < classes.length; ++i) {
			if (componentDefMap_.containsKey(classes[i])) {
				processTooManyRegistration(classes[i], componentDef);
			} else {
				componentDefMap_.put(classes[i], componentDef);
			}
		}
		String componentName = componentDef.getComponentName();
		if (componentName != null) {
			if (componentDefMap_.containsKey(componentName)) {
				processTooManyRegistration(componentName, componentDef);
			} else {
				componentDefMap_.put(componentName, componentDef);
			}
		}
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getComponentDefSize()
	 */
	public int getComponentDefSize() {
		return componentDefList_.size();
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getComponentDef(int)
	 */
	public ComponentDef getComponentDef(int index) {
		return (ComponentDef) componentDefList_.get(index);
	}

	/**
	 * @see org.seasar.framework.container.S2Container#getComponentDef(java.lang.Class)
	 */
	public ComponentDef getComponentDef(Class componentClass) {
		return getComponentDef0(componentClass);
	}
	
	/**
	 * @see org.seasar.framework.container.S2Container#getComponentDef(java.lang.String)
	 */
	public ComponentDef getComponentDef(String componentName) {
		return getComponentDef0(componentName);
	}

	private ComponentDef getComponentDef0(Object key)
		throws ComponentNotFoundRuntimeException {

		ComponentDef cd = (ComponentDef) componentDefMap_.get(key);
		if (cd == null) {
			throw new ComponentNotFoundRuntimeException(key);
		}
		return cd;
	}
	
	public boolean hasComponentDef(Class componentClass) {
		return componentDefMap_.containsKey(componentClass);
	}
	
	public boolean hasComponentDef(String componentName) {
		return componentDefMap_.containsKey(componentName);
	}

	/**
	 * @see org.seasar.framework.container.S2Container#include(org.seasar.framework.container.S2Container)
	 */
	public void include(S2Container child) {
		for (int i = 0; i < child.getComponentDefSize(); ++i) {
			register(child.getComponentDef(i));
		}

	}

	/**
	 * @see org.seasar.framework.container.S2Container#getSelContext()
	 */
	public SelContext getSelContext() {
		return selContext_;
	}

	/**
	 * @see org.seasar.framework.container.S2Container#init()
	 */
	public void init() {
		for (int i = 0; i < getComponentDefSize(); ++i) {
			getComponentDef(i).init();
		}
	}

	/**
	 * @see org.seasar.framework.container.S2Container#destroy()
	 */
	public void destroy() {
		for (int i = getComponentDefSize() - 1; 0 <= i; --i) {
			try {
				getComponentDef(i).destroy();
			} catch (Throwable t) {
				t.printStackTrace();
			}

		}
	}

	private static Class[] getAssignableClasses(Class componentClass) {
		Set classes = new HashSet();
		for (Class clazz = componentClass;
			clazz != Object.class && clazz != null;
			clazz = clazz.getSuperclass()) {
			classes.add(clazz);
			Class[] interfaces = clazz.getInterfaces();
			for (int i = 0; i < interfaces.length; ++i) {
				classes.add(interfaces[i]);
			}
		}
		return (Class[]) classes.toArray(new Class[classes.size()]);
	}

	private void processTooManyRegistration(
		Object key,
		ComponentDef componentDef) {

		ComponentDef cd = (ComponentDef) componentDefMap_.get(key);
		if (cd instanceof TooManyRegistrationComponentDef) {
			((TooManyRegistrationComponentDef) cd).addComponentClass(
				componentDef.getComponentClass());
		} else {
			TooManyRegistrationComponentDef tmrcf =
				new TooManyRegistrationComponentDef(key);
			tmrcf.addComponentClass(cd.getComponentClass());
			tmrcf.addComponentClass(componentDef.getComponentClass());
			componentDefMap_.put(key, tmrcf);
		}
	}
}
