package org.seasar.framework.aop.impl;

import java.lang.reflect.Method;

import net.sf.cglib.proxy.MethodProxy;

import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.Joinpoint;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.exception.EmptyRuntimeException;

/**
 * @author higa
 *
 */
public final class JoinpointImpl implements Joinpoint {

	private Object target_;
	private Class targetClass_;
	private Method method_;
	private Object[] args_;
	private MethodProxy methodProxy_;
	private Aspect[] aspects_;
	private int aspectsIndex_ = 0;

	public JoinpointImpl(
		Object target,
		Class targetClass,
		Method method,
		Object[] args,
		MethodProxy methodProxy,
		Aspect[] aspects)
		throws EmptyRuntimeException {

		if (target == null) {
			throw new EmptyRuntimeException("target");
		}
		if (targetClass == null) {
			throw new EmptyRuntimeException("targetClass");
		}
		if (method == null) {
			throw new EmptyRuntimeException("method");
		}
		if (methodProxy == null) {
			throw new EmptyRuntimeException("methodProxy");
		}
		if (aspects == null) {
			throw new EmptyRuntimeException("aspects");
		}

		target_ = target;
		targetClass_ = targetClass;
		method_ = method;
		args_ = args;
		methodProxy_ = methodProxy;
		aspects_ = aspects;
	}

	/**
	 * @see org.seasar.framework.aop.Joinpoint#getTarget()
	 */
	public Object getTarget() {
		return target_;
	}

	/**
	 * @see org.seasar.framework.aop.Joinpoint#getTargetClass()
	 */
	public Class getTargetClass() {
		return targetClass_;
	}

	/**
	 * @see org.seasar.framework.aop.Joinpoint#getMethod()
	 */
	public Method getMethod() {
		return method_;
	}

	/**
	 * @see org.seasar.framework.aop.Joinpoint#getArgs()
	 */
	public Object[] getArgs() {
		return args_;
	}

	/**
	 * @see org.seasar.framework.aop.Joinpoint#proceed()
	 */
	public Object proceed() throws Throwable {
		while (aspectsIndex_ < aspects_.length) {
			Aspect current = aspects_[aspectsIndex_];
			++aspectsIndex_;
			Pointcut pointcut = current.getPointcut();
			if (pointcut.isApplied(method_)) {
				return current.getAroundAdvice().invoke(this);
			}
		}
		return methodProxy_.invokeSuper(target_, args_);
	}
}