package org.seasar.framework.aop.advices;

import org.seasar.framework.aop.AroundAdvice;
import org.seasar.framework.aop.Joinpoint;

/**
 * @author higa
 *
 */
public class TraceAdvice implements AroundAdvice {

	/**
	 * @see org.seasar.framework.aop.AroundAdvice#invoke(org.seasar.framework.aop.Joinpoint)
	 */
	public Object invoke(Joinpoint joinpoint) throws Throwable {
		StringBuffer buf = new StringBuffer(100);
		buf.append(joinpoint.getTargetClass().getName());
		buf.append("#");
		buf.append(joinpoint.getMethod().getName());
		buf.append("(");
		Object[] args = joinpoint.getArgs(); 
		if (args != null && args.length > 0) { 
			for (int i = 0; i < args.length; ++i) {
				buf.append(args[i]);
				buf.append(", ");
			}
			buf.setLength(buf.length() - 2);
		}
		buf.append(")");
		System.out.println("BEGIN " + buf);
		try {
			Object ret = joinpoint.proceed();
			buf.append(" : ");
			buf.append(ret);
			return ret;
		} catch (Throwable t) {
			buf.append(" Throwable:");
			buf.append(t);
			throw t;
		} finally {
			System.out.println("END " + buf);
		}
	}

}
